/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.UUID;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;
import org.hdiv.state.Page;
import org.hdiv.state.Parameter;
import org.hdiv.state.RandomTokenType;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataComposer
implements IDataComposer {
    private static final Logger log = LoggerFactory.getLogger(AbstractDataComposer.class);
    protected ISession session;
    protected UidGenerator uidGenerator;
    protected IPage page;
    Deque<IState> states;
    protected HDIVConfig hdivConfig;
    protected RequestContextHolder context;
    protected final StringBuilder sb = new StringBuilder(128);
    private final String hdivParameterName;

    public AbstractDataComposer(RequestContextHolder context) {
        this.context = context;
        this.hdivParameterName = context.getHdivParameterName();
    }

    @Override
    public String getHdivParameterName() {
        return this.hdivParameterName;
    }

    @Override
    public void init() {
        this.setPage(new Page(new UUID(0L, 0L)));
        this.states = new ArrayDeque<IState>();
    }

    protected Deque<IState> getStates() {
        return this.states;
    }

    public void initPage(String parentStateId) {
        this.setPage(new Page(this.session.getPageId(this.context)));
        this.page.setParentStateId(parentStateId);
    }

    public void initPage() {
        this.initPage(null);
    }

    @Override
    public String compose(String parameter, String value, boolean editable) {
        return this.compose(parameter, value, editable, false);
    }

    @Override
    public String compose(String action, String parameter, String value, boolean editable) {
        return this.compose(action, parameter, value, editable, false, "UTF-8");
    }

    @Override
    public String compose(String parameter, String value, boolean editable, boolean isActionParam) {
        return this.compose(parameter, value, editable, isActionParam, "UTF-8");
    }

    @Override
    public String compose(String parameter, String value, boolean editable, String editableName) {
        return this.compose(parameter, value, editable, editableName, false, null, "UTF-8");
    }

    @Override
    public String compose(String action, String parameter, String value, boolean editable, boolean isActionParam, String charEncoding) {
        IState state = this.states.peek();
        if (state.getAction() != null && state.getAction().trim().length() == 0) {
            state.setAction(action);
        }
        return this.compose(parameter, value, editable, isActionParam, charEncoding);
    }

    @Override
    public String compose(String parameter, String value, boolean editable, boolean isActionParam, String charEncoding) {
        return this.compose(parameter, value, editable, null, isActionParam, null, charEncoding);
    }

    public String compose(String parameter, String value, boolean editable, String editableName, boolean isActionParam, Method method) {
        return this.compose(parameter, value, editable, editableName, isActionParam, method, "UTF-8");
    }

    @Override
    public final String composeParams(String parameters, Method method, String charEncoding) {
        if (parameters == null || parameters.length() == 0) {
            return null;
        }
        IState state = this.states.peek();
        state.setParams(parameters);
        if (this.hdivConfig.getConfidentiality()) {
            parameters = this.applyConfidentialityToParams(parameters);
        }
        return parameters;
    }

    protected String applyConfidentialityToParams(String parameters) {
        HashMap<String, Integer> pCount = new HashMap<String, Integer>();
        String newParameters = parameters = parameters.replaceAll("&amp;", "&");
        int beginIndex = 0;
        int ampIndex = parameters.indexOf(38);
        int endIndex = ampIndex >= 0 ? ampIndex : parameters.length();
        do {
            int index;
            String param;
            String name;
            if (this.isConfidentialParam(name = param.substring(0, index = (index = (param = parameters.substring(beginIndex, endIndex)).indexOf(61)) < 0 ? param.length() : index))) {
                Integer count = (Integer)pCount.get(name);
                int num = count == null ? 0 : count + 1;
                pCount.put(name, num);
                newParameters = HDIVUtil.replaceOnce(newParameters, param, name + "=" + num);
            }
            beginIndex = endIndex + 1;
            if ((endIndex = parameters.indexOf(38, endIndex + 1)) >= 0) continue;
            endIndex = parameters.length();
        } while (endIndex > beginIndex);
        return newParameters;
    }

    @Override
    public String composeFormField(String parameter, String value, boolean editable, String editableName) {
        return this.composeFormField(parameter, value, editable, editableName, false);
    }

    @Override
    public String composeFormField(String parameter, String value, boolean editable, String editableName, boolean actionParam) {
        return this.compose(parameter, value, editable, editableName, actionParam, Method.POST, "UTF-8");
    }

    @Override
    public String compose(String parameterName, String value, boolean editable, String editableName, boolean isActionParam, Method method, String charEncoding) {
        if (!this.isRequestStarted()) {
            return value;
        }
        IParameter parameter = this.composeParameter(parameterName, value, editable, editableName, isActionParam, charEncoding);
        if (this.isConfidentialParam(parameterName) && (editableName == null || !HDIVUtil.isNonConfidentialType(editableName))) {
            return parameter.getConfidentialValue();
        }
        return value;
    }

    protected boolean isConfidentialParam(String parameterName) {
        if (!this.hdivConfig.getConfidentiality()) {
            return false;
        }
        if (this.hdivConfig.isStartParameter(parameterName)) {
            return false;
        }
        if (this.isUserDefinedNonValidationParameter(parameterName)) {
            return false;
        }
        return !this.hdivConfig.isParameterWithoutConfidentiality(this.context, parameterName);
    }

    protected boolean isUserDefinedNonValidationParameter(String parameter) {
        String action = this.states.peek().getAction();
        if (this.hdivConfig.isParameterWithoutValidation(action, parameter)) {
            if (log.isDebugEnabled()) {
                log.debug("parameter " + parameter + " doesn't need validation. It is user defined parameter.");
            }
            return true;
        }
        return false;
    }

    protected IParameter composeParameter(String parameterName, String value, boolean editable, String editableDataType, boolean isActionParam, String charEncoding) {
        IState state;
        IParameter parameter;
        String decodedValue = null;
        if (!editable) {
            decodedValue = HDIVUtil.getDecodedValue(this.sb, value, charEncoding);
        }
        if ((parameter = (state = this.states.peek()).getParameter(parameterName)) != null) {
            if (parameter.isEditable() != editable) {
                parameter.setEditable(editable);
            }
            parameter.addValue(decodedValue);
        } else {
            parameter = this.createParameter(parameterName, decodedValue, editable, editableDataType, isActionParam, charEncoding);
            state.addParameter(parameter);
        }
        return parameter;
    }

    protected IParameter createParameter(String parameterName, String decodedValue, boolean editable, String editableDataType, boolean isActionParam, String charEncoding) {
        return new Parameter(parameterName, decodedValue, editable, editableDataType, isActionParam);
    }

    @Override
    public void mergeParameters(String oldParameter, String newParameter) {
        IState state = this.states.peek();
        IParameter storedParameter = state.getParameter(oldParameter);
        if (!storedParameter.getValues().isEmpty()) {
            IParameter parameter = this.composeParameter(newParameter, storedParameter.getValuePosition(0), false, "", false, "UTF-8");
            for (int i = 1; i < storedParameter.getValues().size(); ++i) {
                parameter.addValue(storedParameter.getValuePosition(i));
            }
        }
    }

    @Override
    public boolean isRequestStarted() {
        return !this.states.isEmpty();
    }

    @Override
    public void addFlowId(String id) {
        this.page.setFlowId(id);
    }

    protected final String getStateSuffix(RandomTokenType type) {
        String randomToken = this.page.getRandomToken(type);
        if (randomToken == null) {
            randomToken = this.uidGenerator.generateUid().toString();
            this.page.setRandomToken(randomToken, type);
        }
        return randomToken;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public final IPage getPage() {
        return this.page;
    }

    public void setPage(IPage page) {
        this.page = page;
    }

    public void setUidGenerator(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }

    public void setHdivConfig(HDIVConfig hdivConfig) {
        this.hdivConfig = hdivConfig;
    }

    @Override
    public StringBuilder getBuilder() {
        return this.sb;
    }
}

