/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.context;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hdiv.context.HttpSessionModel;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.filter.AsyncRequestWrapper;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.filter.ValidationContext;
import org.hdiv.session.SessionModel;
import org.hdiv.util.HDIVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContext
implements RequestContextHolder {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected SessionModel session;
    protected String modifyParameterName;
    protected String hdivParameterName;
    private String requestURI;
    private String baseURL;
    private UUID currentPageId;
    private Boolean isAjaxRequest;
    private IDataComposer dataComposer;
    private long renderTime;
    private final Logger log = LoggerFactory.getLogger(RequestContextHolder.class);
    private String formStateId;
    private String redirect;
    private ValidationContext validationContext;
    private final ServletContext servletContext;

    public RequestContext(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        this.request = request;
        this.response = response;
        this.requestURI = request.getRequestURI();
        request.setAttribute("HdivRC", (Object)this);
        this.servletContext = servletContext;
        this.doCreateSession();
    }

    @Deprecated
    public void doCreateSession() {
        this.session = new HttpSessionModel(this.request.getSession());
    }

    public final void update(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    @Deprecated
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public SessionModel getSession() {
        return this.session;
    }

    @Override
    public String getHdivParameterName() {
        return this.hdivParameterName;
    }

    public void setHdivParameterName(String name) {
        this.hdivParameterName = name;
    }

    @Override
    public String getHdivModifyParameterName() {
        return this.modifyParameterName;
    }

    public void setHdivModifyParameterName(String name) {
        this.modifyParameterName = name;
    }

    @Override
    public String getHdivState() {
        return this.request.getParameter(this.getHdivParameterName());
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    @Override
    public UUID getCurrentPageId() {
        return this.currentPageId;
    }

    @Override
    public void setCurrentPageId(UUID currentPageId) {
        this.currentPageId = currentPageId;
    }

    @Override
    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public final boolean isAjax() {
        if (this.isAjaxRequest == null) {
            String xRequestedWithValue = this.request.getHeader("x-requested-with");
            this.isAjaxRequest = xRequestedWithValue != null ? "XMLHttpRequest".equalsIgnoreCase(xRequestedWithValue) : false;
        }
        return this.isAjaxRequest;
    }

    public void clearAjax() {
        this.isAjaxRequest = null;
    }

    @Override
    public String getUrlWithoutContextPath() {
        return this.requestURI.substring(this.request.getContextPath().length());
    }

    @Override
    public IDataComposer getDataComposer() {
        return this.dataComposer;
    }

    @Override
    public void setDataComposer(IDataComposer dataComposer) {
        this.dataComposer = dataComposer;
    }

    @Override
    public void addRenderTime(long time) {
        time = System.nanoTime() - time;
        if (this.log.isDebugEnabled()) {
            this.log.debug("render-time-processUrl (ms): " + (double)time / 1000000.0);
        }
        this.renderTime += time;
    }

    @Override
    public long getRenderTime() {
        return this.renderTime;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.request.getAttribute(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object value) {
        this.request.setAttribute(attributeName, value);
    }

    @Override
    public boolean isAsync() {
        RequestWrapper wrapper = HDIVUtil.getNativeRequest((ServletRequest)this.request, RequestWrapper.class);
        if (wrapper != null && wrapper instanceof AsyncRequestWrapper) {
            AsyncRequestWrapper asyncWrapper = (AsyncRequestWrapper)wrapper;
            return asyncWrapper.isAsyncRequest();
        }
        return false;
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    @Override
    public String getFormStateId() {
        return this.formStateId;
    }

    @Override
    public void setFormStateId(String formStateId) {
        this.formStateId = formStateId;
        this.request.setAttribute("hdivFormStateId", (Object)formStateId);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return this.request.getParameterNames();
    }

    @Override
    public void addEditableParameter(String name) {
        if (this.request instanceof RequestWrapper) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Editable parameter [" + name + "] added.");
            }
            RequestWrapper wrapper = (RequestWrapper)this.request;
            wrapper.addEditableParameter(name);
        }
    }

    @Override
    public String getMessage(String key, String o) {
        return HDIVUtil.getMessage(this.request, key, o, Locale.getDefault());
    }

    protected ServletRequest getNativeRequest(ServletRequest request, Class<?> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return request;
            }
            if (request instanceof ServletRequestWrapper) {
                return this.getNativeRequest(((ServletRequestWrapper)request).getRequest(), requiredType);
            }
        }
        return null;
    }

    @Override
    public void addParameterToRequest(String name, String[] value) {
        RequestWrapper wrapper = this.request instanceof RequestWrapper ? (RequestWrapper)this.request : (RequestWrapper)this.getNativeRequest((ServletRequest)this.request, RequestWrapper.class);
        if (wrapper == null) {
            String errorMessage = HDIVUtil.getMessage(this.request, "helper.notwrapper");
            throw new HDIVException(errorMessage);
        }
        wrapper.addParameter(name, value);
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.request.getParameterValues(name);
    }

    @Override
    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public String getServletPath() {
        return this.request.getServletPath();
    }

    @Override
    public void setRedirectAction(String redirect) {
        this.redirect = redirect;
    }

    @Override
    public String getRedirectAction() {
        return this.redirect;
    }

    @Override
    public void setHdivState(String hdivState) {
        HDIVUtil.setHdivState(this.request, hdivState);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public String getHeader(String header) {
        return this.request.getHeader(header);
    }

    @Override
    public <T extends ValidationContext> T getValidationContext() {
        return (T)this.validationContext;
    }

    @Override
    public void setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

