/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.context;

import javax.servlet.http.HttpSession;
import org.hdiv.session.SessionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionModel
implements SessionModel {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionModel.class);
    private final HttpSession session;

    public HttpSessionModel(HttpSession session) {
        this.session = session;
    }

    public Object getAttribute(String name) {
        if (this.session != null) {
            try {
                return this.session.getAttribute(name);
            }
            catch (IllegalStateException e) {
                log.debug("It was not possible to get an attribute from HttpSession. Msg: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public void removeAttribute(String name) {
        if (this.session != null) {
            try {
                this.session.removeAttribute(name);
            }
            catch (IllegalStateException e) {
                log.debug("It was not possible to remove an attribute from HttpSession. Msg: {}", (Object)e.getMessage());
            }
        }
    }

    public void setAttribute(String name, Object cache) {
        if (this.session != null) {
            try {
                this.session.setAttribute(name, cache);
            }
            catch (IllegalStateException e) {
                log.debug("It was not possible to set an attribute from HttpSession. Msg: {}", (Object)e.getMessage());
            }
        }
    }
}

