/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.StartPage;
import org.hdiv.config.Strategy;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.state.scope.StateScopeType;
import org.hdiv.util.Method;
import org.hdiv.validator.EditableDataValidationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDIVConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HDIVConfig.class);
    public static final String DEFAULT_STATE_PARAMETER_NAME = "_HDIV_STATE_";
    public static final String DEFAULT_MODIFY_STATE_PARAMETER_NAME = "_MODIFY_HDIV_STATE_";
    protected transient PatternMatcherFactory patternMatcherFactory;
    protected StartPage[] startPages = new StartPage[0];
    protected List<PatternMatcher> startParameters = new ArrayList<PatternMatcher>();
    protected String errorPage;
    protected String sessionExpiredLoginPage;
    protected String sessionExpiredHomePage;
    protected boolean confidentiality = true;
    private boolean pentestingActive = false;
    protected Map<PatternMatcher, List<PatternMatcher>> paramsWithoutValidation;
    protected EditableDataValidationProvider editableDataValidationProvider;
    protected boolean avoidCookiesIntegrity = false;
    protected boolean avoidCookiesConfidentiality = false;
    protected boolean avoidValidationInUrlsWithoutParams = false;
    protected List<PatternMatcher> protectedURLPatterns;
    protected List<String> excludedURLExtensions;
    protected boolean showErrorPageOnEditableValidation = false;
    protected boolean reuseExistingPageInAjaxRequest = false;
    protected Map<PatternMatcher, String> longLivingPages = new HashMap<PatternMatcher, String>();
    private boolean urlObfuscation = false;
    private boolean integrityValidation = true;
    private boolean editableValidation = true;
    protected boolean editableFieldsRequiredByDefault = false;
    private boolean multipartIntegration = true;

    @Deprecated
    public void setStrategy(Strategy strategy) {
    }

    public boolean isStartParameter(String parameter) {
        for (PatternMatcher matcher : this.startParameters) {
            if (!matcher.matches(parameter)) continue;
            return true;
        }
        return false;
    }

    private void addStartPage(StartPage startPage) {
        if (log.isDebugEnabled()) {
            log.debug("Added a StartPage: " + startPage);
        }
        ArrayList<StartPage> pages = new ArrayList<StartPage>(Arrays.asList(this.startPages));
        pages.add(startPage);
        this.startPages = pages.toArray(new StartPage[pages.size()]);
    }

    public boolean isStartPage(String target, Method method) {
        return this.getStartPage(target, method) != null;
    }

    public StartPage getStartPage(String target, Method method) {
        for (int i = 0; i < this.startPages.length; ++i) {
            StartPage startPage = this.startPages[i];
            PatternMatcher m = startPage.compiledPattern;
            if (!m.matches(target) || !startPage.isAnyMethod() && startPage.method != method) continue;
            return startPage;
        }
        return null;
    }

    public boolean hasExtensionToExclude(String path) {
        if (this.excludedURLExtensions == null) {
            return false;
        }
        int pos = path.indexOf(63);
        if (pos > 0) {
            path = path.substring(0, pos);
        }
        if (path.length() == 0) {
            return false;
        }
        if (path.charAt(path.length() - 1) == '/') {
            return false;
        }
        int pound = path.indexOf(35);
        if (pound >= 0) {
            path = path.substring(0, pound);
        }
        int size = this.excludedURLExtensions.size();
        for (int i = 0; i < size; ++i) {
            if (!path.endsWith(this.excludedURLExtensions.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterWithoutConfidentiality(RequestContextHolder context, String paramName) {
        String modifyHdivStateParameterName = context.getHdivModifyParameterName();
        return modifyHdivStateParameterName != null && modifyHdivStateParameterName.equals(paramName);
    }

    public boolean isParameterWithoutValidation(String action, String parameter) {
        if (action == null) {
            return false;
        }
        if (this.paramsWithoutValidation == null) {
            return false;
        }
        for (Map.Entry<PatternMatcher, List<PatternMatcher>> entry : this.paramsWithoutValidation.entrySet()) {
            if (!entry.getKey().matches(action)) continue;
            for (PatternMatcher paramMatcher : entry.getValue()) {
                if (!paramMatcher.matches(parameter)) continue;
                return true;
            }
        }
        return false;
    }

    public StateScopeType isLongLivingPages(String url) {
        for (Map.Entry<PatternMatcher, String> page : this.longLivingPages.entrySet()) {
            PatternMatcher m = page.getKey();
            if (!m.matches(url)) continue;
            return StateScopeType.byName(page.getValue());
        }
        return null;
    }

    public boolean needValidation(String parameter, String hdivParameter) {
        return !parameter.equals(hdivParameter) && !this.isStartParameter(parameter);
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            errorPage = "/" + errorPage;
        }
        this.errorPage = errorPage;
        if (errorPage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(errorPage);
            this.addStartPage(new StartPage((Method)null, matcher));
        }
    }

    public String getSessionExpiredLoginPage() {
        return this.sessionExpiredLoginPage;
    }

    public void setSessionExpiredLoginPage(String sessionExpiredLoginPage) {
        if (sessionExpiredLoginPage != null && !sessionExpiredLoginPage.startsWith("/")) {
            sessionExpiredLoginPage = "/" + sessionExpiredLoginPage;
        }
        this.sessionExpiredLoginPage = sessionExpiredLoginPage;
        if (sessionExpiredLoginPage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(sessionExpiredLoginPage);
            this.addStartPage(new StartPage((Method)null, matcher));
        }
    }

    public String getSessionExpiredHomePage() {
        return this.sessionExpiredHomePage;
    }

    public void setSessionExpiredHomePage(String sessionExpiredHomePage) {
        if (sessionExpiredHomePage != null && !sessionExpiredHomePage.startsWith("/")) {
            sessionExpiredHomePage = "/" + sessionExpiredHomePage;
        }
        this.sessionExpiredHomePage = sessionExpiredHomePage;
        if (sessionExpiredHomePage != null) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(sessionExpiredHomePage);
            this.addStartPage(new StartPage((Method)null, matcher));
        }
    }

    public boolean getConfidentiality() {
        return this.confidentiality;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }

    public void setParamsWithoutValidation(Map<String, List<String>> paramsWithoutValidation) {
        this.paramsWithoutValidation = new HashMap<PatternMatcher, List<PatternMatcher>>();
        for (Map.Entry<String, List<String>> entry : paramsWithoutValidation.entrySet()) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(entry.getKey());
            List<PatternMatcher> paramMatchers = this.paramsWithoutValidation.get(matcher);
            if (paramMatchers == null) {
                paramMatchers = new ArrayList<PatternMatcher>();
                this.paramsWithoutValidation.put(matcher, paramMatchers);
            }
            for (String param : entry.getValue()) {
                PatternMatcher paramMatcher = this.patternMatcherFactory.getPatternMatcher(param);
                paramMatchers.add(paramMatcher);
            }
        }
    }

    public void setUserStartPages(List<StartPage> userStartPages) {
        for (StartPage startPage : userStartPages) {
            PatternMatcher matcher = this.patternMatcherFactory.getPatternMatcher(startPage.getPattern());
            startPage.setCompiledPattern(matcher);
            this.addStartPage(startPage);
        }
    }

    public void setUserStartParameters(List<String> userStartParameters) {
        for (String useStartParameter : userStartParameters) {
            this.startParameters.add(this.patternMatcherFactory.getPatternMatcher(useStartParameter));
        }
    }

    public boolean isCookiesConfidentialityActivated() {
        return !this.avoidCookiesConfidentiality;
    }

    public void setAvoidCookiesConfidentiality(boolean avoidCookiesConfidentiality) {
        this.avoidCookiesConfidentiality = avoidCookiesConfidentiality;
    }

    public boolean isCookiesIntegrityActivated() {
        return !this.avoidCookiesIntegrity;
    }

    public void setAvoidCookiesIntegrity(boolean avoidCookiesIntegrity) {
        this.avoidCookiesIntegrity = avoidCookiesIntegrity;
    }

    public boolean isValidationInUrlsWithoutParamsActivated() {
        return !this.avoidValidationInUrlsWithoutParams;
    }

    public void setAvoidValidationInUrlsWithoutParams(Boolean avoidValidationInUrlsWithoutParams) {
        this.avoidValidationInUrlsWithoutParams = avoidValidationInUrlsWithoutParams;
    }

    public void setProtectedExtensions(List<String> protectedExtensions) {
        this.protectedURLPatterns = new ArrayList<PatternMatcher>();
        for (String protectedExtension : protectedExtensions) {
            this.protectedURLPatterns.add(this.patternMatcherFactory.getPatternMatcher(protectedExtension));
        }
    }

    public void setExcludedExtensions(List<String> excludedExtensions) {
        if (this.excludedURLExtensions == null) {
            this.excludedURLExtensions = new ArrayList<String>();
        }
        this.excludedURLExtensions.addAll(excludedExtensions);
    }

    public List<PatternMatcher> getProtectedURLPatterns() {
        return this.protectedURLPatterns;
    }

    public List<String> getExcludedURLExtensions() {
        return this.excludedURLExtensions;
    }

    public boolean isRandomName() {
        return false;
    }

    @Deprecated
    public void setRandomName(boolean randomName) {
        if (randomName) {
            this.noLongerSupportedDisclaimer("RandomName");
        }
    }

    @Deprecated
    public Strategy getStrategy() {
        return Strategy.MEMORY;
    }

    @Deprecated
    public boolean isDebugMode() {
        return !this.isIntegrityValidation();
    }

    public void setDebugMode(boolean debugMode) {
        this.setEditableValidation(!debugMode);
        this.setIntegrityValidation(!debugMode);
    }

    public boolean isShowErrorPageOnEditableValidation() {
        return this.showErrorPageOnEditableValidation;
    }

    public void setShowErrorPageOnEditableValidation(boolean showErrorPageOnEditableValidation) {
        this.showErrorPageOnEditableValidation = showErrorPageOnEditableValidation;
    }

    public boolean isReuseExistingPageInAjaxRequest() {
        return this.reuseExistingPageInAjaxRequest;
    }

    public void setReuseExistingPageInAjaxRequest(boolean reuseExistingPageInAjaxRequest) {
        this.reuseExistingPageInAjaxRequest = reuseExistingPageInAjaxRequest;
    }

    public void setPatternMatcherFactory(PatternMatcherFactory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public String getStateParameterName() {
        return DEFAULT_STATE_PARAMETER_NAME;
    }

    @Deprecated
    public void setStateParameterName(String stateParameterName) {
        if (!stateParameterName.equals(DEFAULT_STATE_PARAMETER_NAME)) {
            this.noLongerSupportedDisclaimer("StateParameterName");
        }
    }

    public String getModifyStateParameterName() {
        return DEFAULT_MODIFY_STATE_PARAMETER_NAME;
    }

    @Deprecated
    public void setModifyStateParameterName(String modifyStateParameterName) {
        if (!modifyStateParameterName.equals(DEFAULT_MODIFY_STATE_PARAMETER_NAME)) {
            this.noLongerSupportedDisclaimer("ModifyStateParameterName");
        }
    }

    public void setLongLivingPages(Map<String, String> longLivingPages) {
        for (Map.Entry<String, String> page : longLivingPages.entrySet()) {
            PatternMatcher pattern = this.patternMatcherFactory.getPatternMatcher(page.getKey());
            String scope = page.getValue();
            this.longLivingPages.put(pattern, scope);
        }
    }

    public void setEditableDataValidationProvider(EditableDataValidationProvider editableDataValidationProvider) {
        this.editableDataValidationProvider = editableDataValidationProvider;
    }

    public EditableDataValidationProvider getEditableDataValidationProvider() {
        return this.editableDataValidationProvider;
    }

    public boolean isUrlObfuscation() {
        return this.urlObfuscation;
    }

    public void setUrlObfuscation(boolean urlObfuscation) {
        this.urlObfuscation = urlObfuscation;
    }

    public boolean getEditableFieldsRequiredByDefault() {
        return this.editableFieldsRequiredByDefault;
    }

    public void setEditableFieldsRequiredByDefault(boolean editableFieldsRequiredByDefault) {
        this.editableFieldsRequiredByDefault = editableFieldsRequiredByDefault;
    }

    public boolean isMultipartIntegration() {
        return this.multipartIntegration;
    }

    public void setMultipartIntegration(boolean multipartIntegration) {
        this.multipartIntegration = multipartIntegration;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("");
        result = result.append(" Confidentiality=").append(this.getConfidentiality());
        result.append(" avoidCookiesIntegrity=").append(this.avoidCookiesIntegrity);
        result.append(" avoidCookiesConfidentiality=").append(this.avoidCookiesConfidentiality);
        result.append(" avoidValidationInUrlsWithoutParams=").append(this.avoidValidationInUrlsWithoutParams);
        result.append(" strategy=").append((Object)this.getStrategy());
        result.append(" randomName=").append(this.isRandomName());
        result.append(" errorPage=").append(this.getErrorPage());
        result.append(" sessionExpiredLoginPage=").append(this.sessionExpiredLoginPage);
        result.append(" sessionExpiredHomePage=").append(this.sessionExpiredHomePage);
        result.append(" excludedExtensions=").append(this.excludedURLExtensions);
        result.append(" protectedExtensions=").append(this.getProtectedURLPatterns());
        result.append(" startPages=").append(this.startPages);
        result.append(" startParameters=").append(this.startParameters);
        result.append(" paramsWithoutValidation=").append(this.paramsWithoutValidation);
        result.append(" longLivingPages=").append(this.longLivingPages);
        result.append(" debugMode=").append(this.isDebugMode());
        result.append(" showErrorPageOnEditableValidation=").append(this.showErrorPageOnEditableValidation);
        result.append(" multipartIntegration=").append(this.multipartIntegration);
        return result.toString();
    }

    private void noLongerSupportedDisclaimer(String feature) {
        System.err.println("**************************************************************");
        System.err.println("*                                                            *");
        System.err.println("*       This feature is no longer supported under Hdiv CE    *");
        System.err.println("*                                                            *");
        System.err.println("**************************************************************");
        System.err.println("Feature:" + feature);
    }

    public boolean isIntegrityValidation() {
        return this.integrityValidation;
    }

    public boolean isEditableValidation() {
        return this.editableValidation;
    }

    public void setIntegrityValidation(boolean integrityValidation) {
        this.integrityValidation = integrityValidation;
    }

    public void setEditableValidation(boolean editableValidation) {
        this.editableValidation = editableValidation;
    }

    public boolean isPentestingActive() {
        return this.pentestingActive;
    }

    public void setPentestingActive(boolean pentestingActive) {
        this.pentestingActive = pentestingActive;
    }
}

