/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.factory.ValidationRepositoryFactoryBean;
import org.hdiv.config.validations.DefaultValidationParser;
import org.hdiv.config.xml.ConfigBeanDefinitionParser;
import org.hdiv.validator.DefaultEditableDataValidationProvider;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.Validation;
import org.hdiv.validator.ValidationRepository;
import org.hdiv.web.validator.EditableParameterValidator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableValidationsBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String EDITABLE_VALIDATION_PROVIDER_BEAN_NAME = "org.hdiv.validator.EditableDataValidationProvider";
    public static final String DEFAULT_EDITABLE_VALIDATIONS_BEAN_NAME = "org.hdiv.defaultEditableValidations";
    public static final String EDITABLE_VALIDATOR_BEAN_NAME = "hdivEditableValidator";
    private final boolean springMvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)EditableValidationsBeanDefinitionParser.class.getClassLoader());
    private static boolean jsr303Present = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)EditableValidationsBeanDefinitionParser.class.getClassLoader());
    protected final boolean springMvcModulePresent = ClassUtils.isPresent((String)"org.hdiv.web.servlet.support.HdivRequestDataValueProcessor", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return EDITABLE_VALIDATION_PROVIDER_BEAN_NAME;
    }

    protected Class<?> getBeanClass(Element element) {
        return DefaultEditableDataValidationProvider.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder bean) {
        String registerDefaultsValue;
        Object source = parserContext.extractSource((Object)element);
        LinkedHashMap<ValidationRepositoryFactoryBean.ValidationTargetData, List<String>> validationsData = new LinkedHashMap<ValidationRepositoryFactoryBean.ValidationTargetData, List<String>>();
        ArrayList<IValidation> defaultValidations = new ArrayList<IValidation>();
        RuntimeBeanReference repositoryRef = this.createValidationRepository(source, parserContext, validationsData, defaultValidations);
        bean.getBeanDefinition().getPropertyValues().addPropertyValue("validationRepository", (Object)repositoryRef);
        boolean registerDefaults = true;
        Node named = element.getAttributes().getNamedItem("registerDefaults");
        if (named != null && (registerDefaultsValue = named.getTextContent()) != null) {
            registerDefaults = Boolean.TRUE.toString().equalsIgnoreCase(registerDefaultsValue);
        }
        if (registerDefaults) {
            List<IValidation> defaultVals = this.createDefaultEditableValidations(element, parserContext);
            defaultValidations.addAll(defaultVals);
        }
        NodeList list = element.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1 || !"validationRule".equalsIgnoreCase(node.getLocalName())) continue;
            this.processValidationRule(node, validationsData);
        }
        if (this.springMvcPresent && this.springMvcModulePresent) {
            parserContext.getRegistry().registerBeanDefinition(EDITABLE_VALIDATOR_BEAN_NAME, (BeanDefinition)this.createValidator(source, parserContext));
        }
    }

    protected RuntimeBeanReference createValidationRepository(Object source, ParserContext parserContext, Map<ValidationRepositoryFactoryBean.ValidationTargetData, List<String>> validationsData, List<IValidation> defaultValidations) {
        RootBeanDefinition bean = new RootBeanDefinition(ValidationRepositoryFactoryBean.class);
        bean.setSource(source);
        bean.setRole(2);
        RuntimeBeanReference beanRef = new RuntimeBeanReference(ConfigBeanDefinitionParser.PATTERN_MATCHER_FACTORY_NAME);
        bean.getPropertyValues().addPropertyValue("patternMatcherFactory", (Object)beanRef);
        bean.getPropertyValues().addPropertyValue("defaultValidations", defaultValidations);
        bean.getPropertyValues().addPropertyValue("validationsData", validationsData);
        String name = ValidationRepository.class.getName();
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected void processValidationRule(Node node, Map<ValidationRepositoryFactoryBean.ValidationTargetData, List<String>> validationsData) {
        String value = node.getTextContent();
        List<String> ids = this.convertToList(value);
        NamedNodeMap attributes = node.getAttributes();
        Node urlNode = attributes.getNamedItem("url");
        Node paramsNode = attributes.getNamedItem("parameters");
        if (urlNode != null || paramsNode != null) {
            String enableDefaultsVal;
            ValidationRepositoryFactoryBean.ValidationTargetData data = new ValidationRepositoryFactoryBean.ValidationTargetData();
            if (urlNode != null) {
                String url = urlNode.getTextContent();
                data.setUrl(url);
            }
            if (paramsNode != null) {
                String params = paramsNode.getTextContent();
                List<String> paramsList = this.convertToList(params);
                data.setParams(paramsList);
            }
            boolean enableDefaults = true;
            Node named = attributes.getNamedItem("enableDefaults");
            if (named != null && (enableDefaultsVal = named.getTextContent()) != null) {
                enableDefaults = Boolean.TRUE.toString().equalsIgnoreCase(enableDefaultsVal);
            }
            if (enableDefaults) {
                ids.add(DEFAULT_EDITABLE_VALIDATIONS_BEAN_NAME);
            }
            validationsData.put(data, ids);
        }
    }

    protected List<String> convertToList(String data) {
        if (data == null || data.length() == 0) {
            return new ArrayList<String>();
        }
        String[] result = data.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String val : result) {
            list.add(val.trim());
        }
        return list;
    }

    protected List<IValidation> createDefaultEditableValidations(Element element, ParserContext parserContext) {
        DefaultValidationParser parser = new DefaultValidationParser();
        parser.readDefaultValidations();
        List<Map<DefaultValidationParser.ValidationParam, String>> validations = parser.getValidations();
        ArrayList<IValidation> defaultValidations = new ArrayList<IValidation>();
        for (Map<DefaultValidationParser.ValidationParam, String> validation : validations) {
            String id = validation.get((Object)DefaultValidationParser.ValidationParam.ID);
            String regex = validation.get((Object)DefaultValidationParser.ValidationParam.REGEX);
            Validation validationBean = new Validation();
            validationBean.setName(id);
            validationBean.setDefaultValidation(true);
            validationBean.setRejectedPattern(regex);
            defaultValidations.add((IValidation)validationBean);
        }
        Object source = parserContext.extractSource((Object)element);
        RootBeanDefinition bean = new RootBeanDefinition(ListFactoryBean.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("sourceList", defaultValidations);
        parserContext.getRegistry().registerBeanDefinition(DEFAULT_EDITABLE_VALIDATIONS_BEAN_NAME, (BeanDefinition)bean);
        return defaultValidations;
    }

    protected RootBeanDefinition createValidator(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(EditableParameterValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        if (jsr303Present) {
            RootBeanDefinition validatorDef = new RootBeanDefinition(LocalValidatorFactoryBean.class);
            validatorDef.setSource(source);
            validatorDef.setRole(2);
            String validatorName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)validatorDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)validatorDef, validatorName));
            bean.getPropertyValues().addPropertyValue("innerValidator", (Object)new RuntimeBeanReference(validatorName));
        }
        return bean;
    }
}

