/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.validations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hdiv.exception.HDIVException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationParser
extends DefaultHandler {
    private static final String DEFAULT_VALIDATION_PATH = "org/hdiv/config/validations/defaultEditableValidations.xml";
    private final List<Map<ValidationParam, String>> validations = new ArrayList<Map<ValidationParam, String>>();
    private Map<ValidationParam, String> validation = null;

    public void readDefaultValidations() {
        this.readDefaultValidations(DEFAULT_VALIDATION_PATH);
    }

    public void readDefaultValidations(String filePath) {
        try {
            ClassLoader classLoader = DefaultValidationParser.class.getClassLoader();
            InputStream is = classLoader.getResourceAsStream(filePath);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("validation".equals(qName)) {
            this.validation = new EnumMap<ValidationParam, String>(ValidationParam.class);
            String id = attributes.getValue("id");
            this.validation.put(ValidationParam.ID, id);
            this.validations.add(this.validation);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String val = new String(ch, start, length).trim();
        if (val.length() > 0) {
            this.validation.put(ValidationParam.REGEX, val);
        }
    }

    public List<Map<ValidationParam, String>> getValidations() {
        return this.validations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationParam {
        ID,
        REGEX;

    }
}

