/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.springmvc;

import org.hdiv.config.annotation.condition.ConditionalOnFramework;
import org.hdiv.config.annotation.condition.SupportedFramework;
import org.hdiv.config.annotation.configuration.ConfigTools;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.config.multipart.SpringMVCMultipartConfig;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.web.servlet.support.HdivRequestDataValueProcessor;
import org.hdiv.web.validator.EditableParameterValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.support.RequestDataValueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
@ConditionalOnFramework(value=SupportedFramework.SPRING_MVC)
public class SpringMvcConfigurationSupport
implements ApplicationListener<ContextRefreshedEvent> {
    protected static final boolean jsr303Present = ClassUtils.isPresent((String)"javax.validation.Validator", (ClassLoader)SpringMvcConfigurationSupport.class.getClassLoader());
    @Autowired
    protected FormUrlProcessor formUrlProcessor;
    @Autowired
    protected LinkUrlProcessor linkUrlProcessor;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ConfigurableApplicationContext context;
        ApplicationContext applicationContext = event.getApplicationContext();
        if (ConfigTools.springSecurityPresent && applicationContext instanceof ConfigurableApplicationContext && applicationContext.getBean("requestDataValueProcessor") instanceof CsrfRequestDataValueProcessor && (context = (ConfigurableApplicationContext)applicationContext).getBeanFactory() instanceof DefaultSingletonBeanRegistry) {
            DefaultSingletonBeanRegistry factory = (DefaultSingletonBeanRegistry)context.getBeanFactory();
            factory.destroySingleton("requestDataValueProcessor");
            context.getBeanFactory().registerSingleton("requestDataValueProcessor", (Object)this.requestDataValueProcessor());
        }
    }

    public RequestDataValueProcessor requestDataValueProcessor() {
        HdivRequestDataValueProcessor processor = new HdivRequestDataValueProcessor();
        processor.setFormUrlProcessor(this.formUrlProcessor);
        processor.setLinkUrlProcessor(this.linkUrlProcessor);
        if (ConfigTools.springSecurityPresent) {
            processor.setInnerRequestDataValueProcessor((RequestDataValueProcessor)new CsrfRequestDataValueProcessor());
        }
        return processor;
    }

    @Bean
    public static BeanDefinitionRegistryPostProcessor requestDataValueProcessorPostProcessor() {
        return ConfigTools.requestDataValueProcessorPostProcessor(HdivRequestDataValueProcessor.class);
    }

    @Bean(name={"hdivEditableValidator"})
    public Validator editableParameterValidator() {
        EditableParameterValidator validator = new EditableParameterValidator();
        if (jsr303Present) {
            validator.setInnerValidator((Validator)this.editableLocalValidatorFactoryBean());
        }
        return validator;
    }

    @Bean
    public LocalValidatorFactoryBean editableLocalValidatorFactoryBean() {
        return new LocalValidatorFactoryBean();
    }

    @Bean
    public IMultipartConfig securityMultipartConfig() {
        return new SpringMVCMultipartConfig();
    }
}

