/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.config.StartPage;
import org.hdiv.config.annotation.ParamExclusionRegistration;
import org.hdiv.config.annotation.UrlExclusionRegistration;
import org.hdiv.regex.PatternMatcherFactory;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionRegistry {
    private final PatternMatcherFactory patternMatcherFactory;
    private final List<UrlExclusionRegistration> urlRegistrations = new ArrayList<UrlExclusionRegistration>();
    private final List<ParamExclusionRegistration> paramRegistrations = new ArrayList<ParamExclusionRegistration>();

    public ExclusionRegistry(PatternMatcherFactory patternMatcherFactory) {
        this.patternMatcherFactory = patternMatcherFactory;
    }

    public UrlExclusionRegistration addUrlExclusions(String ... urlPatterns) {
        Assert.notEmpty((Object[])urlPatterns, (String)"Url patterns are required");
        UrlExclusionRegistration registration = new UrlExclusionRegistration(urlPatterns);
        this.urlRegistrations.add(registration);
        return registration;
    }

    public ParamExclusionRegistration addParamExclusions(String ... parameterPatterns) {
        Assert.notEmpty((Object[])parameterPatterns, (String)"Parameter patterns are required");
        ParamExclusionRegistration registration = new ParamExclusionRegistration(new ArrayList<String>(Arrays.asList(parameterPatterns)));
        this.paramRegistrations.add(registration);
        return registration;
    }

    protected List<StartPage> getUrlExclusions() {
        ArrayList<StartPage> allStartPages = new ArrayList<StartPage>();
        for (UrlExclusionRegistration regitration : this.urlRegistrations) {
            List<StartPage> startPages = regitration.getExclusions();
            for (StartPage sp : startPages) {
                sp.setCompiledPattern(this.patternMatcherFactory.getPatternMatcher(sp.getPattern()));
                allStartPages.add(sp);
            }
        }
        return allStartPages;
    }

    protected List<String> getParamExclusions() {
        ArrayList<String> paramExclusions = new ArrayList<String>();
        for (ParamExclusionRegistration regitration : this.paramRegistrations) {
            String urlPattern = regitration.getUrlPattern();
            if (urlPattern != null) continue;
            paramExclusions.addAll(regitration.getParameterPatterns());
        }
        return paramExclusions;
    }

    protected Map<String, List<String>> getParamExclusionsForUrl() {
        LinkedHashMap<String, List<String>> paramExclusions = new LinkedHashMap<String, List<String>>();
        for (ParamExclusionRegistration regitration : this.paramRegistrations) {
            String urlPattern = regitration.getUrlPattern();
            if (urlPattern == null) continue;
            List<String> params = (List<String>)paramExclusions.get(urlPattern);
            if (params == null) {
                params = regitration.getParameterPatterns();
            } else {
                params.addAll(regitration.getParameterPatterns());
            }
            paramExclusions.put(urlPattern, params);
        }
        return paramExclusions;
    }
}

