/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterpriseEngineAccessor;
import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.GuestPolyglotIsolateServices;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativeEngine;
import com.oracle.truffle.polyglot.enterprise.NativeExecutionListener;
import com.oracle.truffle.polyglot.enterprise.NativeObjectReferences;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObject;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.ProcessHandler;

abstract class NativeEngineDispatch
extends AbstractPolyglotImpl.AbstractEngineDispatch {
    private final EnterprisePolyglotImpl impl;
    private final AbstractPolyglotImpl.APIAccess apiAccess;

    protected NativeEngineDispatch(EnterprisePolyglotImpl enterprisePolyglotImpl) {
        super((AbstractPolyglotImpl)enterprisePolyglotImpl);
        this.impl = enterprisePolyglotImpl;
        this.apiAccess = enterprisePolyglotImpl.getAPIAccess();
    }

    public abstract OptionDescriptors getOptions(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close(Object object, Object object2, boolean bl) {
        NativeEngine nativeEngine = (NativeEngine)((Object)object);
        NativeIsolate nativeIsolate = ((NativeObject)object).getIsolate();
        NativeIsolateThread nativeIsolateThread = nativeIsolate.tryEnter();
        if (nativeIsolateThread != null) {
            try {
                this.closeImpl(object, object2, bl);
            }
            finally {
                nativeIsolateThread.leave();
            }
        } else {
            Object object3 = nativeEngine.getLocalEngine();
            this.apiAccess.getEngineDispatch(object3).close(this.apiAccess.getEngineReceiver(object3), object3, bl);
        }
    }

    abstract void closeImpl(Object var1, Object var2, boolean var3);

    public final void setAPI(Object object, Object object2) {
        ((NativeEngine)((Object)object)).setAPI(object2);
    }

    public final Object createContext(Object object, SandboxPolicy sandboxPolicy, OutputStream outputStream, OutputStream outputStream2, InputStream inputStream, boolean bl, Object object2, Object object3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, Predicate<String> predicate, Map<String, String> map, Map<String, String[]> map2, String[] stringArray, Object object4, Object object5, boolean bl7, ProcessHandler processHandler, Object object6, Map<String, String> map3, ZoneId zoneId, Object object7, String string, String string2, ClassLoader classLoader, boolean bl8, boolean bl9) {
        NativeEngine nativeEngine = (NativeEngine)((Object)object);
        Object object8 = nativeEngine.getLocalEngine();
        AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch = this.apiAccess.getEngineDispatch(object8);
        Object object9 = this.apiAccess.getEngineReceiver(object8);
        Object object10 = abstractEngineDispatch.createContext(object9, sandboxPolicy, outputStream, outputStream2, inputStream, bl, object2, this.apiAccess.getPolyglotAccessAll(), bl2, bl3, bl4, bl5, bl6, predicate, this.impl.localOptions(map), Collections.emptyMap(), EnterprisePolyglotImpl.EMPTY_LANGUAGES, object4, object5, false, null, this.apiAccess.getEnvironmentAccessNone(), map3, null, null, string, string2, classLoader, bl8, bl9);
        AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService = EnterpriseEngineAccessor.ENGINE.getHostService(this.apiAccess.getEngineReceiver(object8));
        Object object11 = this.apiAccess.getContextReceiver(object10);
        AbstractPolyglotImpl.AbstractContextDispatch abstractContextDispatch = this.apiAccess.getContextDispatch(object10);
        AbstractPolyglotImpl.LogHandler logHandler = EnterpriseEngineAccessor.ENGINE.getContextLogHandler(object11);
        NativeObjectReferences nativeObjectReferences = NativeObjectReferences.create();
        ProcessHandler processHandler2 = processHandler != null ? processHandler : this.impl.newDefaultProcessHandler();
        long l2 = nativeEngine.getPolyglotIsolateServices().createContext((Object)nativeEngine, sandboxPolicy, outputStream, outputStream2, inputStream, bl, object3, object4, this.impl.getIO().getFileSystem(object4), bl2, bl3, bl4, bl5, bl6, bl7, map, map2, stringArray, string, string2, processHandler2, object6, map3, zoneId != null ? zoneId : ZoneId.systemDefault(), nativeEngine.getHostStackHeadRoom(), abstractHostLanguageService, bl8, bl9, logHandler, nativeObjectReferences);
        NativeContext nativeContext = new NativeContext(nativeEngine.getIsolate(), l2, object10, nativeObjectReferences, nativeEngine.getPolyglotIsolateServices());
        Object object12 = this.apiAccess.newContext(this.impl.getHostContextDispatch(), (Object)nativeContext, nativeEngine.getAPI());
        abstractContextDispatch.setAPI(object11, object12);
        nativeEngine.onContextCreated(object12);
        this.initializeSandboxInstrument(nativeContext, sandboxPolicy);
        return object12;
    }

    private void initializeSandboxInstrument(NativeContext nativeContext, SandboxPolicy sandboxPolicy) {
        if (sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED)) {
            try {
                nativeContext.getPolyglotIsolateServices().ensureInstrumentCreated((Object)nativeContext, "sandbox");
            }
            catch (Exception exception) {
                throw EnterpriseEngineAccessor.ENGINE.wrapGuestException(this.apiAccess.getContextReceiver(nativeContext.getLocalContext()), (Throwable)exception);
            }
        }
    }

    public final Set<Object> getCachedSources(Object object) {
        NativeEngine nativeEngine = (NativeEngine)((Object)object);
        return nativeEngine.getSourceCache().getCachedSources();
    }

    public final String getImplementationName(Object object) {
        return String.format("%s Isolated", this.getImplementationNameImpl(object));
    }

    abstract String getImplementationNameImpl(Object var1);

    public abstract Map<String, Object> getInstruments(Object var1);

    public abstract Map<String, Object> getLanguages(Object var1);

    public final Object attachExecutionListener(Object object, Consumer<Object> consumer, Consumer<Object> consumer2, boolean bl, boolean bl2, boolean bl3, Predicate<Object> predicate, Predicate<String> predicate2, boolean bl4, boolean bl5, boolean bl6) {
        NativeEngine nativeEngine = (NativeEngine)((Object)object);
        AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch = this.apiAccess.getEngineDispatch(nativeEngine.getLocalEngine());
        Object object2 = this.apiAccess.getEngineReceiver(nativeEngine.getLocalEngine());
        Object object3 = abstractEngineDispatch.attachExecutionListener(object2, consumer, consumer2, bl, bl2, bl3, predicate, predicate2, bl4, bl5, bl6);
        Consumer<Object> consumer3 = NativeEngineDispatch.toHostExceptionConsumer(consumer, abstractEngineDispatch, object2);
        Consumer<Object> consumer4 = NativeEngineDispatch.toHostExceptionConsumer(consumer2, abstractEngineDispatch, object2);
        NativeObject nativeObject = (NativeObject)this.attachExecutionListenerImpl((Object)nativeEngine, consumer3, consumer4, bl, bl2, bl3, predicate, predicate2, bl4, bl5, bl6);
        return this.impl.getManagement().newExecutionListener(this.impl.getExecutionListenerDispatch(), (Object)new NativeExecutionListener((AutoCloseable)object3, nativeObject));
    }

    private static Consumer<Object> toHostExceptionConsumer(Consumer<Object> consumer, AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch, Object object) {
        if (consumer != null) {
            return object2 -> {
                try {
                    consumer.accept(object2);
                }
                catch (Throwable throwable) {
                    throw abstractEngineDispatch.hostToGuestException(object, throwable);
                }
            };
        }
        return null;
    }

    abstract Object attachExecutionListenerImpl(Object var1, Consumer<Object> var2, Consumer<Object> var3, boolean var4, boolean var5, boolean var6, Predicate<Object> var7, Predicate<String> var8, boolean var9, boolean var10, boolean var11);

    public abstract Object requirePublicLanguage(Object var1, String var2);

    public abstract Object requirePublicInstrument(Object var1, String var2);

    public final void shutdown(Object object) {
        NativeIsolateThread nativeIsolateThread = ((NativeEngine)((Object)object)).getIsolate().tryEnter();
        if (nativeIsolateThread != null) {
            try {
                this.shutdownImpl(object);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }
    }

    abstract void shutdownImpl(Object var1);

    public final RuntimeException hostToGuestException(Object object, Throwable throwable) {
        NativeEngine nativeEngine = (NativeEngine)((Object)object);
        Object object2 = nativeEngine.getLocalEngine();
        AbstractPolyglotImpl.AbstractEngineDispatch abstractEngineDispatch = this.apiAccess.getEngineDispatch(object2);
        Object object3 = this.apiAccess.getEngineReceiver(object2);
        return abstractEngineDispatch.hostToGuestException(object3, throwable);
    }

    static AbstractPolyglotImpl.AbstractEngineDispatch resolveDelegate(GuestPolyglotIsolateServices.EngineHolder engineHolder) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getEngineDispatch(engineHolder.engine);
    }

    static Object resolveReceiver(GuestPolyglotIsolateServices.EngineHolder engineHolder) {
        return EnterprisePolyglotImpl.instance.getAPIAccess().getEngineReceiver(engineHolder.engine);
    }
}

