/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotByteSequenceFactory;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import org.graalvm.polyglot.io.ByteSequence;

class PolyglotByteSequence
implements ByteSequence,
PolyglotWrapper {
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    final Object guestObject;
    final PolyglotLanguageContext languageContext;
    final Cache cache;

    PolyglotByteSequence(Object buffer, PolyglotLanguageContext languageContext) {
        this.guestObject = buffer;
        this.languageContext = languageContext;
        this.cache = Cache.lookup(languageContext, buffer.getClass());
    }

    @CompilerDirectives.TruffleBoundary
    public static PolyglotByteSequence create(PolyglotLanguageContext languageContext, Object buffer) {
        return new PolyglotByteSequence(buffer, languageContext);
    }

    public String toString() {
        return PolyglotWrapper.toString(this);
    }

    public int hashCode() {
        return PolyglotWrapper.hashCode(this.languageContext, this.guestObject);
    }

    public boolean equals(Object o) {
        if (o instanceof PolyglotByteSequence) {
            return PolyglotWrapper.equals(this.languageContext, this.guestObject, ((PolyglotByteSequence)o).guestObject);
        }
        return false;
    }

    public int length() {
        return (Integer)this.cache.length.call(null, this.languageContext, this.guestObject);
    }

    public byte byteAt(int index) {
        return (Byte)this.cache.byteAt.call(null, this.languageContext, this.guestObject, index);
    }

    public byte[] toByteArray() {
        return (byte[])this.cache.toByteArray.call(null, this.languageContext, this.guestObject);
    }

    @Override
    public Object getGuestObject() {
        return this.guestObject;
    }

    @Override
    public PolyglotContextImpl getContext() {
        return this.languageContext.context;
    }

    @Override
    public PolyglotLanguageContext getLanguageContext() {
        return this.languageContext;
    }

    static final class Cache {
        final PolyglotLanguageInstance languageInstance;
        final Class<?> receiverClass;
        final CallTarget byteAt;
        final CallTarget toByteArray;
        final CallTarget length;

        Cache(PolyglotLanguageInstance languageInstance, Class<?> receiverClass) {
            this.languageInstance = languageInstance;
            this.receiverClass = receiverClass;
            this.byteAt = PolyglotByteSequenceFactory.CacheFactory.ByteAtNodeGen.create(this).getCallTarget();
            this.toByteArray = PolyglotByteSequenceFactory.CacheFactory.ToByteArrayNodeGen.create(this).getCallTarget();
            this.length = PolyglotByteSequenceFactory.CacheFactory.LengthNodeGen.create(this).getCallTarget();
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass) {
            Cache cache = HostToGuestRootNode.lookupHostCodeCache(languageContext, receiverClass, Cache.class);
            if (cache == null) {
                cache = HostToGuestRootNode.installHostCodeCache(languageContext, receiverClass, new Cache(languageContext.getLanguageInstance(), receiverClass), Cache.class);
            }
            assert (cache.receiverClass == receiverClass);
            return cache;
        }

        static abstract class ByteAtNode
        extends PolyglotByteSequenceNode {
            ByteAtNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                Object key = args[2];
                assert (key instanceof Integer);
                int offset = (Integer)key;
                try {
                    return interop.readBufferByte(receiver, offset);
                }
                catch (InvalidBufferOffsetException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, offset);
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "byteAt()");
                }
            }

            @Override
            protected String getOperationName() {
                return "byteAt";
            }
        }

        static abstract class ToByteArrayNode
        extends PolyglotByteSequenceNode {
            ToByteArrayNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            static Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached InlinedBranchProfile error) {
                long size;
                try {
                    size = interop.getBufferSize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()");
                }
                if (size > 0x7FFFFFF7L) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()");
                }
                int intSize = (int)size;
                byte[] outArray = new byte[intSize];
                try {
                    interop.readBuffer(receiver, 0L, outArray, 0, intSize);
                    return outArray;
                }
                catch (InvalidBufferOffsetException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.invalidBufferOffset(languageContext, receiver, e.getByteOffset());
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw PolyglotInteropErrors.bufferUnsupported(languageContext, receiver, "toByteArray()");
                }
            }

            @Override
            protected String getOperationName() {
                return "byteAt";
            }
        }

        static abstract class LengthNode
        extends PolyglotByteSequenceNode {
            LengthNode(Cache cache) {
                super(cache);
            }

            @Specialization(limit="LIMIT")
            Object doCached(PolyglotLanguageContext languageContext, Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary interop) {
                try {
                    return (int)interop.getBufferSize(receiver);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere(e);
                }
            }

            @Override
            protected String getOperationName() {
                return "size";
            }
        }

        static abstract class PolyglotByteSequenceNode
        extends HostToGuestRootNode {
            static final int LIMIT = 5;
            final Cache cache;

            PolyglotByteSequenceNode(Cache cache) {
                super(cache.languageInstance);
                this.cache = cache;
            }

            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotByteSequence<" + String.valueOf(this.cache.receiverClass) + ">." + this.getOperationName();
            }

            protected abstract String getOperationName();
        }
    }
}

