/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.LanguageAccessor;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.graalvm.polyglot.PolyglotException;

public final class TruffleStackTrace
extends Exception {
    private static final TruffleStackTrace EMPTY = new TruffleStackTrace(Collections.emptyList(), 0);
    private List<TruffleStackTraceElement> frames;
    private final int lazyFrames;
    private Throwable materializedHostException;

    private TruffleStackTrace(List<TruffleStackTraceElement> frames, int lazyFrames) {
        this.frames = frames;
        this.lazyFrames = lazyFrames;
    }

    private void materializeHostException() {
        if (this.materializedHostException == null) {
            this.materializedHostException = new Exception();
        }
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    StackTraceElement[] getInternalStackTrace() {
        Throwable hostException = this.materializedHostException;
        if (hostException == null) {
            hostException = this;
        }
        StackTraceElement[] hostFrames = hostException.getStackTrace();
        if (this.lazyFrames == 0) {
            return hostFrames;
        }
        StackTraceElement[] extended = new StackTraceElement[hostFrames.length + this.lazyFrames];
        System.arraycopy(hostFrames, 0, extended, this.lazyFrames, hostFrames.length);
        return extended;
    }

    @Override
    public String toString() {
        return "Attached Guest Language Frames (" + this.frames.size() + ")";
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleStackTraceElement> getStackTrace(Throwable throwable) {
        TruffleStackTrace stack = TruffleStackTrace.fillIn(throwable);
        if (stack != null) {
            return stack.frames;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<TruffleStackTraceElement> getAsynchronousStackTrace(CallTarget target, Frame frame) {
        Objects.requireNonNull(target, "CallTarget must not be null");
        Objects.requireNonNull(frame, "Frame must not be null");
        assert (LanguageAccessor.ENGINE.hasCurrentContext());
        return LanguageAccessor.ACCESSOR.nodeSupport().findAsynchronousFrames(target, frame);
    }

    private static LazyStackTrace findImpl(Throwable t) {
        assert (!(t instanceof ControlFlowException));
        for (Throwable suppressed : t.getSuppressed()) {
            if (!(suppressed instanceof LazyStackTrace)) continue;
            return (LazyStackTrace)suppressed;
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleStackTrace fillIn(Throwable throwable) {
        int stackFrameLimit;
        Node topCallSite;
        Objects.requireNonNull(throwable);
        if (throwable instanceof ControlFlowException) {
            return EMPTY;
        }
        if (throwable instanceof PolyglotException) {
            return EMPTY;
        }
        LazyStackTrace lazy = TruffleStackTrace.getOrCreateLazyStackTrace(throwable);
        if (lazy.stackTrace != null) {
            return lazy.stackTrace;
        }
        boolean isTruffleException = LanguageAccessor.EXCEPTIONS.isException(throwable);
        if (isTruffleException) {
            topCallSite = LanguageAccessor.EXCEPTIONS.getLocation(throwable);
            stackFrameLimit = LanguageAccessor.EXCEPTIONS.getStackTraceElementLimit(throwable);
        } else {
            topCallSite = null;
            stackFrameLimit = -1;
        }
        ArrayList<TracebackElement> elements = new ArrayList<TracebackElement>();
        TracebackElement currentElement = lazy.current;
        while (currentElement != null) {
            elements.add(currentElement);
            currentElement = currentElement.last;
        }
        ArrayList<TruffleStackTraceElement> frames = new ArrayList<TruffleStackTraceElement>();
        ListIterator iterator = elements.listIterator(elements.size());
        while (iterator.hasPrevious()) {
            TracebackElement element = (TracebackElement)iterator.previous();
            if (element.root != null) {
                int bytecodeIndex = LanguageAccessor.NODES.findBytecodeIndex(element.root.getRootNode(), topCallSite, element.frame);
                frames.add(new TruffleStackTraceElement(topCallSite, element.root, element.frame, bytecodeIndex));
                topCallSite = null;
            }
            if (element.callNode == null) continue;
            topCallSite = element.callNode;
        }
        int lazyFrames = frames.size();
        TruffleStackTrace.addFramesByStackWalking(stackFrameLimit, topCallSite, frames);
        TruffleStackTrace fullStackTrace = new TruffleStackTrace(frames, lazyFrames);
        if (isTruffleException && !TruffleStackTrace.isHostException(throwable)) {
            fullStackTrace.materializeHostException();
        }
        lazy.stackTrace = fullStackTrace;
        return fullStackTrace;
    }

    private static boolean isHostException(Throwable throwable) {
        Object polyglotEngine = LanguageAccessor.ENGINE.getCurrentPolyglotEngine();
        return polyglotEngine != null && LanguageAccessor.ENGINE.getHostService(polyglotEngine).isHostException((Object)throwable);
    }

    static void addStackFrameInfo(Node callNode, RootCallTarget target, Throwable t, Frame currentFrame) {
        if (t instanceof ControlFlowException) {
            return;
        }
        MaterializedFrame frame = null;
        if (currentFrame != null && LanguageAccessor.NODES.isCaptureFramesForTrace(target.getRootNode(), CompilerDirectives.inCompiledCode())) {
            frame = currentFrame.materialize();
        }
        TruffleStackTrace.callInnerAddStackFrameInfo(callNode, target, t, frame);
    }

    private static void callInnerAddStackFrameInfo(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        boolean isException = LanguageAccessor.EXCEPTIONS.isException(t);
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant(isException) && isException) {
            TruffleStackTrace.innerAddStackFrame(callNode, root, t, currentFrame);
        } else {
            TruffleStackTrace.innerAddStackFrameSlow(callNode, root, t, currentFrame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void innerAddStackFrameSlow(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        if (LanguageAccessor.EXCEPTIONS.isException(t)) {
            TruffleStackTrace.innerAddStackFrame(callNode, root, t, currentFrame);
        } else {
            TruffleStackTrace.fillIn(t);
        }
    }

    private static void innerAddStackFrame(Node callNode, RootCallTarget root, Throwable t, MaterializedFrame currentFrame) {
        assert (LanguageAccessor.EXCEPTIONS.isException(t));
        int stackTraceElementLimit = LanguageAccessor.EXCEPTIONS.getStackTraceElementLimit(t);
        LazyStackTrace lazy = (LazyStackTrace)LanguageAccessor.EXCEPTIONS.getLazyStackTrace(t);
        if (lazy == null) {
            lazy = new LazyStackTrace();
            LanguageAccessor.EXCEPTIONS.setLazyStackTrace(t, lazy);
        }
        TruffleStackTrace.appendLazyStackTrace(callNode, root, currentFrame, lazy, stackTraceElementLimit);
    }

    @CompilerDirectives.TruffleBoundary
    static LazyStackTrace getOrCreateLazyStackTrace(Throwable throwable) {
        LazyStackTrace lazy;
        if (LanguageAccessor.EXCEPTIONS.isException(throwable)) {
            lazy = (LazyStackTrace)LanguageAccessor.EXCEPTIONS.getLazyStackTrace(throwable);
            if (lazy == null) {
                lazy = new LazyStackTrace();
                LanguageAccessor.EXCEPTIONS.setLazyStackTrace(throwable, lazy);
            }
        } else {
            lazy = TruffleStackTrace.findImpl(throwable);
            if (lazy == null && !TruffleStackTrace.tryAddSuppressed(throwable, lazy = new LazyStackTrace())) {
                lazy.stackTrace = EMPTY;
            }
        }
        return lazy;
    }

    private static boolean tryAddSuppressed(Throwable throwable, LazyStackTrace lazy) {
        if (throwable instanceof StackOverflowError || throwable instanceof OutOfMemoryError) {
            return false;
        }
        throwable.addSuppressed(lazy);
        return throwable.getSuppressed().length != 0;
    }

    private static void appendLazyStackTrace(Node callNode, RootCallTarget root, MaterializedFrame currentFrame, LazyStackTrace lazy, int stackTraceElementLimit) {
        if (lazy.stackTrace == null) {
            if (stackTraceElementLimit >= 0 && lazy.frameCount >= stackTraceElementLimit) {
                return;
            }
            lazy.current = new TracebackElement(lazy.current, callNode, root, currentFrame);
            if (root != null && LanguageAccessor.ACCESSOR.nodeSupport().countsTowardsStackTraceLimit(root.getRootNode())) {
                ++lazy.frameCount;
            }
        }
    }

    private static void addFramesByStackWalking(final int stackFrameLimit, final Node topCallSite, final List<TruffleStackTraceElement> frames) {
        final int lazyFrames = frames.size();
        if (stackFrameLimit >= 0 && lazyFrames >= stackFrameLimit) {
            return;
        }
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
            boolean first = true;
            int stackFrameIndex = lazyFrames;

            @Override
            public FrameInstance visitFrame(FrameInstance frameInstance) {
                Node callNode;
                if (stackFrameLimit >= 0 && this.stackFrameIndex >= stackFrameLimit) {
                    return frameInstance;
                }
                if (this.first) {
                    callNode = topCallSite;
                    this.first = false;
                } else {
                    callNode = frameInstance.getCallNode();
                }
                RootCallTarget target = (RootCallTarget)frameInstance.getCallTarget();
                RootNode root = target.getRootNode();
                Frame frame = TruffleStackTrace.captureFrame(frameInstance, root);
                int bytecodeIndex = LanguageAccessor.NODES.findBytecodeIndex(root, callNode, frame);
                frames.add(new TruffleStackTraceElement(callNode, target, frame, bytecodeIndex));
                if (target != null && LanguageAccessor.ACCESSOR.nodeSupport().countsTowardsStackTraceLimit(target.getRootNode())) {
                    ++this.stackFrameIndex;
                }
                return null;
            }
        });
    }

    private static Frame captureFrame(FrameInstance frame, RootNode rootNode) {
        return LanguageAccessor.NODES.isCaptureFramesForTrace(rootNode, frame.getCompilationTier() > 0) ? frame.getFrame(FrameInstance.FrameAccess.READ_ONLY) : null;
    }

    static final class LazyStackTrace
    extends Throwable {
        private TracebackElement current;
        private TruffleStackTrace stackTrace;
        public int frameCount;

        LazyStackTrace() {
            super(null, null, false, false);
        }

        public TruffleStackTrace getInternalStackTrace() {
            return this.stackTrace;
        }

        @Override
        public String toString() {
            return "Attached Guest Language Frames (" + (this.frameCount + (this.stackTrace != null ? this.stackTrace.frames.size() : 0)) + ")";
        }
    }

    private static final class TracebackElement {
        private final TracebackElement last;
        private final Node callNode;
        private final RootCallTarget root;
        private final MaterializedFrame frame;

        TracebackElement(TracebackElement last, Node callNode, RootCallTarget root, MaterializedFrame frame) {
            this.last = last;
            this.callNode = callNode;
            this.root = root;
            this.frame = frame;
        }
    }
}

