/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jdk;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.PLATFORM_JNI.class})
@AutomaticallyRegisteredFeature
public final class JNIRegistrationSupport
extends JNIRegistrationUtil
implements InternalFeature {
    private final ConcurrentMap<String, Boolean> registeredLibraries = new ConcurrentHashMap<String, Boolean>();
    private NativeLibraries nativeLibraries = null;
    private boolean isSunMSCAPIProviderReachable = false;
    private final SortedMap<String, SortedSet<String>> shimExports = new TreeMap<String, SortedSet<String>>();
    private FeatureImpl.AfterImageWriteAccessImpl accessImpl;

    public static JNIRegistrationSupport singleton() {
        return (JNIRegistrationSupport)ImageSingletons.lookup(JNIRegistrationSupport.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.nativeLibraries = ((FeatureImpl.BeforeAnalysisAccessImpl)access).getNativeLibraries();
    }

    @Override
    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        if (JNIRegistrationSupport.isWindows()) {
            this.isSunMSCAPIProviderReachable = access.isReachable(JNIRegistrationSupport.clazz((Feature.FeatureAccess)access, "sun.security.mscapi.SunMSCAPI"));
        }
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        this.registerLoadLibraryPlugin(plugins, System.class);
    }

    public void registerLoadLibraryPlugin(GraphBuilderConfiguration.Plugins plugins, Class<?> clazz) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), clazz);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("loadLibrary", new Type[]{String.class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode libnameNode) {
                if (libnameNode.isConstant()) {
                    JNIRegistrationSupport.this.registerLibrary((String)SubstrateObjectConstant.asObject(libnameNode.asConstant()));
                }
                return false;
            }
        });
    }

    void registerLibrary(String libname) {
        if (libname != null && this.registeredLibraries.putIfAbsent(libname, Boolean.TRUE) == null && NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname)) {
            this.nativeLibraries.addStaticJniLibrary(libname, new String[0]);
        }
    }

    boolean isRegisteredLibrary(String libname) {
        return this.registeredLibraries.containsKey(libname);
    }

    void addJvmShimExports(String ... exports) {
        this.addShimExports("jvm", exports);
    }

    void addJavaShimExports(String ... exports) {
        this.addShimExports("java", exports);
    }

    private void addShimExports(String shimName, String ... exports) {
        assert (exports != null && exports.length > 0);
        this.shimExports.computeIfAbsent(shimName, s -> new TreeSet()).addAll(Arrays.asList(exports));
    }

    public void beforeImageWrite(Feature.BeforeImageWriteAccess access) {
        if (JNIRegistrationSupport.isWindows()) {
            ((FeatureImpl.BeforeImageWriteAccessImpl)access).registerLinkerInvocationTransformer(linkerInvocation -> {
                this.shimExports.values().stream().flatMap(Collection::stream).distinct().map("/export:"::concat).forEach(linkerInvocation::addNativeLinkerOption);
                return linkerInvocation;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        this.accessImpl = (FeatureImpl.AfterImageWriteAccessImpl)access;
        try (DebugContext.Scope s = this.accessImpl.getDebugContext().scope((Object)"JDKLibs");){
            if (JNIRegistrationSupport.isWindows()) {
                Path jdkLibDir = Paths.get(System.getProperty("java.home"), "bin");
                this.copyJDKLibraries(jdkLibDir);
                this.makeShimDLLs();
            }
        }
        finally {
            this.accessImpl = null;
        }
    }

    private void copyJDKLibraries(Path jdkLibDir) {
        DebugContext debug = this.accessImpl.getDebugContext();
        try (DebugContext.Scope s = debug.scope((Object)"copy");
             Indent i = debug.logAndIndent("from: %s", (Object)jdkLibDir);){
            for (String libname : new TreeSet(this.registeredLibraries.keySet())) {
                String library = System.mapLibraryName(libname);
                if (NativeLibrarySupport.singleton().isPreregisteredBuiltinLibrary(libname)) {
                    debug.log(2, "%s: SKIPPED", (Object)library);
                    continue;
                }
                if (libname.equals("sunmscapi") && !this.isSunMSCAPIProviderReachable) {
                    debug.log(2, "%s: IGNORED", (Object)library);
                    continue;
                }
                try {
                    Path libraryPath = this.accessImpl.getImagePath().resolveSibling(library);
                    Files.copy(jdkLibDir.resolve(library), libraryPath, StandardCopyOption.REPLACE_EXISTING);
                    BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.JDK_LIB, libraryPath);
                    debug.log("%s: OK", (Object)library);
                }
                catch (NoSuchFileException e) {
                    debug.log(2, "%s: IGNORED", (Object)library);
                }
                catch (IOException e) {
                    VMError.shouldNotReachHere(e);
                }
            }
        }
    }

    private void makeShimDLLs() {
        for (String shimName : this.shimExports.keySet()) {
            DebugContext debug = this.accessImpl.getDebugContext();
            DebugContext.Scope s = debug.scope((Object)(shimName + "ShimDLL"));
            try {
                if (debug.isLogEnabled(2)) {
                    debug.log("exports: %s", (Object)String.join((CharSequence)", ", (Iterable)this.shimExports.get(shimName)));
                }
                this.makeShimDLL(shimName);
            }
            finally {
                if (s == null) continue;
                s.close();
            }
        }
    }

    private void makeShimDLL(String shimName) {
        Path shimDLL = this.accessImpl.getImagePath().resolveSibling(shimName + ".dll");
        Path[] shimDLLDependencies = new Path[]{this.getImageImportLib(), Paths.get("msvcrt.lib", new String[0])};
        assert (ImageSingletons.contains(CCompilerInvoker.class));
        List<String> linkerCommand = ((CCompilerInvoker)ImageSingletons.lookup(CCompilerInvoker.class)).createCompilerCommand(Collections.emptyList(), shimDLL, shimDLLDependencies);
        linkerCommand.addAll(Arrays.asList("/link", "/dll", "/implib:" + shimName + ".lib"));
        for (String export : (SortedSet)this.shimExports.get(shimName)) {
            linkerCommand.add("/export:" + export);
        }
        DebugContext debug = this.accessImpl.getDebugContext();
        try (DebugContext.Scope s = debug.scope((Object)"link");
             DebugContext.Activation a = debug.activate();){
            if (FileUtils.executeCommand(linkerCommand) != 0) {
                VMError.shouldNotReachHere();
            }
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.JDK_LIB_SHIM, shimDLL);
            debug.log("%s.dll: OK", (Object)shimName);
        }
        catch (InterruptedException e) {
            throw new InterruptImageBuilding();
        }
        catch (IOException e) {
            VMError.shouldNotReachHere(e);
        }
    }

    private Path getImageImportLib() {
        Path importLib;
        Path image = this.accessImpl.getImagePath();
        String imageName = String.valueOf(image.getFileName());
        String importLibName = imageName.substring(0, imageName.lastIndexOf(46)) + ".lib";
        Path path = importLib = this.accessImpl.getImageKind().isExecutable ? this.accessImpl.getTempDirectory().resolve(importLibName) : image.resolveSibling(importLibName);
        assert (Files.exists(importLib, new LinkOption[0]));
        return importLib;
    }
}

