/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.code.CompilationGraph;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

@AutomaticallyRegisteredImageSingleton
public final class UninterruptibleAnnotationChecker {
    private final Set<String> violations = new TreeSet<String>();

    private static UninterruptibleAnnotationChecker singleton() {
        return (UninterruptibleAnnotationChecker)ImageSingletons.lookup(UninterruptibleAnnotationChecker.class);
    }

    UninterruptibleAnnotationChecker() {
    }

    public static void checkAfterParsing(ResolvedJavaMethod method, StructuredGraph graph) {
        UninterruptibleAnnotationChecker.singleton().checkAllocations(method, graph);
    }

    public static void checkBeforeCompilation(Collection<HostedMethod> methods) {
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ digraph uninterruptible {");
        }
        UninterruptibleAnnotationChecker c = UninterruptibleAnnotationChecker.singleton();
        for (HostedMethod method : methods) {
            Uninterruptible annotation = (Uninterruptible)method.getAnnotation(Uninterruptible.class);
            CompilationGraph graph = method.compilationInfo.getCompilationGraph();
            c.checkSpecifiedOptions(method, annotation);
            c.checkOverrides(method, annotation);
            c.checkCallees(method, annotation, graph);
            c.checkCallers(method, annotation, graph);
        }
        if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
            System.out.println("/* DOT */ }");
        }
        c.reportViolations();
    }

    private void reportViolations() {
        if (!this.violations.isEmpty()) {
            String message = "Found " + this.violations.size() + " violations of @Uninterruptible usage:";
            for (String violation : this.violations) {
                message = message + System.lineSeparator() + violation;
            }
            throw UserError.abort("%s", message);
        }
    }

    private void checkSpecifiedOptions(HostedMethod method, Uninterruptible methodAnnotation) {
        if (methodAnnotation == null) {
            return;
        }
        if (methodAnnotation.mayBeInlined() && !methodAnnotation.calleeMustBe()) {
            this.violations.add("method " + method.format("%H.%n(%p)") + " is annotated with 'calleeMustBe == false' and 'mayBeInlined == true' at the same time.");
        }
    }

    private void checkOverrides(HostedMethod method, Uninterruptible methodAnnotation) {
        if (methodAnnotation == null) {
            return;
        }
        for (HostedMethod impl : method.getImplementations()) {
            Uninterruptible implAnnotation = (Uninterruptible)impl.getAnnotation(Uninterruptible.class);
            if (implAnnotation != null) {
                if (methodAnnotation.callerMustBe() != implAnnotation.callerMustBe()) {
                    this.violations.add("callerMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                }
                if (methodAnnotation.calleeMustBe() == implAnnotation.calleeMustBe()) continue;
                this.violations.add("calleeMustBe: " + method.format("%H.%n(%p)") + " != " + impl.format("%H.%n(%p)"));
                continue;
            }
            this.violations.add("method " + method.format("%H.%n(%p)") + " is annotated but " + impl.format("%H.%n(%p) is not"));
        }
    }

    private void checkCallees(HostedMethod caller, Uninterruptible callerAnnotation, CompilationGraph graph) {
        if (callerAnnotation == null || graph == null) {
            return;
        }
        for (CompilationGraph.InvokeInfo invoke : graph.getInvokeInfos()) {
            Uninterruptible directCallerAnnotation;
            HostedMethod callee = invoke.getTargetMethod();
            if (Options.PrintUninterruptibleCalleeDOTGraph.getValue().booleanValue()) {
                UninterruptibleAnnotationChecker.printDotGraphEdge(caller, callee);
            }
            if ((directCallerAnnotation = (Uninterruptible)invoke.getDirectCaller().getAnnotation(Uninterruptible.class)) == null) {
                this.violations.add("Unannotated callee: " + invoke.getDirectCaller().format("%H.%n(%p)") + " inlined into annotated caller " + caller.format("%H.%n(%p)") + System.lineSeparator() + invoke.getNodeSourcePosition());
                continue;
            }
            if (!directCallerAnnotation.calleeMustBe() || UninterruptibleAnnotationChecker.isNotInterruptible(callee)) continue;
            this.violations.add("Unannotated callee: " + callee.format("%H.%n(%p)") + " called by annotated caller " + caller.format("%H.%n(%p)") + System.lineSeparator() + invoke.getNodeSourcePosition());
        }
    }

    private void checkCallers(HostedMethod caller, Uninterruptible callerAnnotation, CompilationGraph graph) {
        if (callerAnnotation != null || graph == null) {
            return;
        }
        for (CompilationGraph.InvokeInfo invoke : graph.getInvokeInfos()) {
            HostedMethod callee = invoke.getTargetMethod();
            if (!UninterruptibleAnnotationChecker.isCallerMustBe(callee)) continue;
            this.violations.add("Unannotated caller: " + caller.format("%H.%n(%p)") + " calls annotated callee " + callee.format("%H.%n(%p)"));
        }
    }

    private void checkAllocations(ResolvedJavaMethod method, StructuredGraph graph) {
        Uninterruptible methodAnnotation = (Uninterruptible)method.getAnnotation(Uninterruptible.class);
        if (methodAnnotation != null && graph != null) {
            for (Node node : graph.getNodes()) {
                if (!UninterruptibleAnnotationChecker.isAllocationNode(node)) continue;
                this.violations.add("Annotated method: " + method.format("%H.%n(%p)") + " allocates.");
            }
        }
    }

    public static boolean isAllocationNode(Node node) {
        return node instanceof CommitAllocationNode || node instanceof AbstractNewObjectNode || node instanceof NewMultiArrayNode;
    }

    private static boolean isNotInterruptible(HostedMethod method) {
        return UninterruptibleAnnotationChecker.isUninterruptible(method) || UninterruptibleAnnotationChecker.isNoTransitionCFunction(method);
    }

    private static boolean isUninterruptible(HostedMethod method) {
        return method.getAnnotation(Uninterruptible.class) != null;
    }

    private static boolean isCallerMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = (Uninterruptible)method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.callerMustBe();
    }

    private static boolean isCalleeMustBe(HostedMethod method) {
        Uninterruptible uninterruptibleAnnotation = (Uninterruptible)method.getAnnotation(Uninterruptible.class);
        return uninterruptibleAnnotation != null && uninterruptibleAnnotation.calleeMustBe();
    }

    private static boolean isNoTransitionCFunction(HostedMethod method) {
        CFunction cfunctionAnnotation = (CFunction)method.getAnnotation(CFunction.class);
        InvokeCFunctionPointer invokeCFunctionPointerAnnotation = (InvokeCFunctionPointer)method.getAnnotation(InvokeCFunctionPointer.class);
        return cfunctionAnnotation != null && cfunctionAnnotation.transition() == CFunction.Transition.NO_TRANSITION || invokeCFunctionPointerAnnotation != null && invokeCFunctionPointerAnnotation.transition() == CFunction.Transition.NO_TRANSITION;
    }

    private static void printDotGraphEdge(HostedMethod caller, HostedMethod callee) {
        String calleeColor;
        String callerColor = " [color=black]";
        if (UninterruptibleAnnotationChecker.isUninterruptible(caller)) {
            callerColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(caller)) {
                callerColor = " [color=orange]";
            }
        }
        if (UninterruptibleAnnotationChecker.isUninterruptible(callee)) {
            calleeColor = " [color=blue]";
            if (!UninterruptibleAnnotationChecker.isCalleeMustBe(callee)) {
                calleeColor = " [color=purple]";
            }
        } else {
            calleeColor = " [color=red]";
        }
        if (UninterruptibleAnnotationChecker.isNoTransitionCFunction(callee)) {
            calleeColor = " [color=green]";
        }
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + callerColor);
        System.out.println("/* DOT */    " + callee.format("<%h.%n>") + calleeColor);
        System.out.println("/* DOT */    " + caller.format("<%h.%n>") + " -> " + callee.format("<%h.%n>") + calleeColor);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintUninterruptibleCalleeDOTGraph = new HostedOptionKey<Boolean>(false);
    }
}

