/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.amd64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.amd64.AMD64ReservedRegisters;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

@AutomaticallyRegisteredImageSingleton(value={RegisterDumper.class})
@Platforms(value={Platform.LINUX_AMD64.class})
class AMD64LinuxUContextRegisterDumper
implements UContextRegisterDumper {
    AMD64LinuxUContextRegisterDumper() {
        VMError.guarantee(AMD64.r14.equals((Object)AMD64ReservedRegisters.HEAP_BASE_REGISTER_CANDIDATE));
        VMError.guarantee(AMD64.r15.equals((Object)AMD64ReservedRegisters.THREAD_REGISTER_CANDIDATE));
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext, boolean printLocationInfo, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_linux_amd64_gregs();
        RegisterDumper.dumpReg(log, "RAX ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RAX()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBX ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RBX()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RCX ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RCX()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDX ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RDX()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RBP ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RBP()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSI ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RSI()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RDI ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RDI()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RSP ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RSP()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R8  ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R8()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R9  ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R9()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R10 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R10()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R11 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R11()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R12 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R12()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R13 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R13()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R14 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R14()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "R15 ", gregs.read(Signal.GregEnumLinuxAMD64.REG_R15()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "EFL ", gregs.read(Signal.GregEnumLinuxAMD64.REG_EFL()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
        RegisterDumper.dumpReg(log, "RIP ", gregs.read(Signal.GregEnumLinuxAMD64.REG_RIP()), printLocationInfo, allowJavaHeapAccess, allowUnsafeOperations);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_linux_amd64_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnumLinuxAMD64.REG_R14()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_linux_amd64_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnumLinuxAMD64.REG_R15()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_linux_amd64_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnumLinuxAMD64.REG_RSP()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_linux_amd64_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnumLinuxAMD64.REG_RIP()));
    }
}

