/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import com.oracle.svm.core.jdk.Target_java_lang_Package;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_BuiltinClassLoader;
import com.oracle.svm.core.jdk.Target_jdk_internal_loader_ClassLoaders;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.internal.loader.BootLoader;

@TargetClass(value=BootLoader.class)
final class Target_jdk_internal_loader_BootLoader {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=ConcurrentHashMap.class)
    static ConcurrentHashMap<?, ?> CLASS_LOADER_VALUE_MAP;

    Target_jdk_internal_loader_BootLoader() {
    }

    @Substitute
    static Package getDefinedPackage(String name) {
        if (name != null) {
            Target_java_lang_Package pkg = new Target_java_lang_Package(name, null, null, null, null, null, null, null, null);
            return SubstrateUtil.cast(pkg, Package.class);
        }
        return null;
    }

    @Substitute
    public static Stream<Package> packages() {
        Target_jdk_internal_loader_BuiltinClassLoader bootClassLoader = Target_jdk_internal_loader_ClassLoaders.bootLoader();
        Target_java_lang_ClassLoader systemClassLoader = SubstrateUtil.cast(bootClassLoader, Target_java_lang_ClassLoader.class);
        return systemClassLoader.packages();
    }

    @Delete(value="only used by #packages()")
    private static native String[] getSystemPackageNames();

    @Substitute
    private static Class<?> loadClassOrNull(String name) {
        return ClassForNameSupport.forNameOrNull(name, null);
    }

    @Substitute
    private static Class<?> loadClass(Module module, String name) {
        return ClassForNameSupport.forNameOrNull(name, null);
    }

    @Substitute
    private static boolean hasClassPath() {
        return true;
    }
}

