/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.FieldValueTransformer;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ServiceKeyComputer
implements FieldValueTransformer {
    ServiceKeyComputer() {
    }

    public Object transform(Object receiver, Object originalValue) {
        try {
            Class<?> serviceKey = Class.forName("java.security.Provider$ServiceKey");
            Constructor constructor = ReflectionUtil.lookupConstructor(serviceKey, (Class[])new Class[]{String.class, String.class, Boolean.TYPE});
            return constructor.newInstance("", "", false);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

