/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.truffle.api.SubstrateKnownTruffleTypes;
import com.oracle.svm.truffle.api.SubstrateOptimizedCallTarget;
import java.lang.ref.Reference;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;

public class SubstrateTruffleGraphBuilderPlugins {
    static void registerInvocationPlugins(InvocationPlugins plugins, boolean canDelayIntrinsification, SubstrateKnownTruffleTypes types) {
        SubstrateTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(plugins, canDelayIntrinsification, types);
        SubstrateTruffleGraphBuilderPlugins.registerOptimizedCallTargetPlugins(plugins);
    }

    private static void registerCompilationFinalReferencePlugins(InvocationPlugins plugins, final boolean canDelayIntrinsification, final SubstrateKnownTruffleTypes types) {
        InvocationPlugins.Registration r0 = new InvocationPlugins.Registration(plugins, Reference.class);
        r0.register1("get", InvocationPlugin.Receiver.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                JavaConstant reference;
                if (!canDelayIntrinsification && receiver.isConstant() && (reference = (JavaConstant)receiver.get().asConstant()).isNonNull()) {
                    JavaConstant referent = b.getConstantReflection().readFieldValue(types.referentField, reference);
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)referent, (MetaAccessProvider)b.getMetaAccess()));
                    return true;
                }
                return false;
            }
        });
    }

    private static void registerOptimizedCallTargetPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r0 = new InvocationPlugins.Registration(plugins, SubstrateOptimizedCallTarget.class);
        r0.register0("safepointBarrier", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add((ValueNode)new MembarNode(0));
                return true;
            }
        });
    }
}

