/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.truffle.TruffleBaseFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

@TargetClass(className="com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator", onlyWith={TruffleBaseFeature.IsEnabled.class})
final class Target_com_oracle_truffle_api_staticobject_ArrayBasedShapeGenerator {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetTransformer.class)
    int byteArrayOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetTransformer.class)
    int objectArrayOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=OffsetTransformer.class)
    int shapeOffset;

    Target_com_oracle_truffle_api_staticobject_ArrayBasedShapeGenerator() {
    }

    public static final class OffsetTransformer
    implements RecomputeFieldValue.CustomFieldValueTransformer {
        private static final Class<?> SHAPE_GENERATOR;

        @Override
        public Object transform(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver, Object originalValue) {
            String name;
            Class generatedStorageClass = (Class)ReflectionUtil.readField(SHAPE_GENERATOR, (String)"generatedStorageClass", (Object)receiver);
            switch (original.getName()) {
                case "byteArrayOffset": {
                    name = "primitive";
                    break;
                }
                case "objectArrayOffset": {
                    name = "object";
                    break;
                }
                case "shapeOffset": {
                    name = "shape";
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            Field f = ReflectionUtil.lookupField((Class)generatedStorageClass, (String)name);
            assert (metaAccess instanceof HostedMetaAccess);
            return ((HostedMetaAccess)metaAccess).lookupJavaField(f).getLocation();
        }

        static {
            try {
                SHAPE_GENERATOR = Class.forName("com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator");
            }
            catch (ClassNotFoundException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
    }
}

