/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.hosted.FieldOffsetComputer;
import com.oracle.svm.reflect.target.ReflectionHelper;
import com.oracle.svm.reflect.target.Target_jdk_internal_reflect_FieldAccessor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.util.GuardedAnnotationAccess;
import sun.reflect.generics.repository.FieldRepository;

@TargetClass(value=Field.class)
public final class Target_java_lang_reflect_Field {
    @Alias
    FieldRepository genericInfo;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor fieldAccessor;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    Target_jdk_internal_reflect_FieldAccessor overrideFieldAccessor;
    @Alias
    boolean override;
    @Alias
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
    @Alias
    Target_java_lang_reflect_Field root;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldOffsetComputer.class)
    public int offset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=AnnotatedTypeComputer.class)
    AnnotatedType annotatedType;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=FieldDeletionReasonComputer.class)
    String deletedReason;

    @Alias
    native Target_java_lang_reflect_Field copy();

    @Alias
    native Target_jdk_internal_reflect_FieldAccessor acquireFieldAccessor(boolean var1);

    @Substitute
    Target_jdk_internal_reflect_FieldAccessor getFieldAccessor(Object obj) {
        Target_jdk_internal_reflect_FieldAccessor accessor;
        boolean ov = this.override;
        Target_jdk_internal_reflect_FieldAccessor target_jdk_internal_reflect_FieldAccessor = accessor = ov ? this.overrideFieldAccessor : this.fieldAccessor;
        if (accessor != null) {
            return accessor;
        }
        if (this.deletedReason != null) {
            Field field = SubstrateUtil.cast(this, Field.class);
            throw VMError.unsupportedFeature("Unsupported field " + field.getDeclaringClass().getTypeName() + "." + field.getName() + " is reachable: " + this.deletedReason);
        }
        return this.acquireFieldAccessor(ov);
    }

    @Substitute
    Map<Class<? extends Annotation>, Annotation> declaredAnnotations() {
        Target_java_lang_reflect_Field holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.declaredAnnotations, "Declared annotations must be computed during native image generation.");
    }

    @Substitute
    public AnnotatedType getAnnotatedType() {
        Target_java_lang_reflect_Field holder = ReflectionHelper.getHolder(this);
        return ReflectionHelper.requireNonNull(holder.annotatedType, "Annotated type must be computed during native image generation.");
    }

    public static final class FieldDeletionReasonComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            ResolvedJavaField field = metaAccess.lookupJavaField((Field)receiver);
            Delete annotation = (Delete)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)field, Delete.class);
            return annotation != null ? annotation.value() : null;
        }
    }

    public static final class AnnotatedTypeComputer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            Field field = (Field)receiver;
            return field.getAnnotatedType();
        }
    }
}

