/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.hosted;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.jni.access.JNIAccessFeature;
import com.oracle.svm.jni.access.JNINativeLinkage;
import com.oracle.svm.jni.hosted.JNIGraphKit;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;

class JNINativeCallWrapperMethod
extends CustomSubstitutionMethod {
    private final JNINativeLinkage linkage;

    JNINativeCallWrapperMethod(ResolvedJavaMethod method) {
        super(method);
        this.linkage = JNINativeCallWrapperMethod.createLinkage(method);
    }

    private static JNINativeLinkage createLinkage(ResolvedJavaMethod method) {
        ResolvedJavaMethod unwrapped = method;
        while (unwrapped instanceof WrappedJavaMethod) {
            unwrapped = ((WrappedJavaMethod)unwrapped).getWrapped();
        }
        String className = unwrapped.getDeclaringClass().getName();
        String descriptor = unwrapped.getSignature().toMethodDescriptor();
        return JNIAccessFeature.singleton().makeLinkage(className, unwrapped.getName(), descriptor);
    }

    @Override
    public boolean isSynthetic() {
        return true;
    }

    @Override
    public int getModifiers() {
        int synthetic = 4096;
        return (this.getOriginal().getModifiers() | 0x1000) & 0xFFFFFEDF;
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        JNIGraphKit kit = new JNIGraphKit(debug, providers, method);
        StructuredGraph graph = kit.getGraph();
        InvokeWithExceptionNode handleFrame = kit.nativeCallPrologue();
        Object callAddress = this.linkage.isBuiltInFunction() ? kit.unique(new CGlobalDataLoadAddressNode(this.linkage.getBuiltInAddress())) : kit.nativeCallAddress((ValueNode)kit.createObject(this.linkage));
        InvokeWithExceptionNode environment = kit.environment();
        JavaType javaReturnType = method.getSignature().getReturnType(null);
        JavaType[] javaArgumentTypes = method.toParameterTypes();
        List<ValueNode> javaArguments = kit.loadArguments(javaArgumentTypes);
        ArrayList<ValueNode> jniArguments = new ArrayList<ValueNode>(2 + javaArguments.size());
        ArrayList<JavaType> jniArgumentTypes = new ArrayList<JavaType>(2 + javaArguments.size());
        ResolvedJavaType environmentType = providers.getMetaAccess().lookupJavaType(JNIEnvironment.class);
        ResolvedJavaType objectHandleType = providers.getMetaAccess().lookupJavaType(JNIObjectHandle.class);
        jniArguments.add((ValueNode)environment);
        jniArgumentTypes.add((JavaType)environmentType);
        if (method.isStatic()) {
            JavaConstant clazz = providers.getConstantReflection().asJavaClass(method.getDeclaringClass());
            ConstantNode clazzNode = ConstantNode.forConstant((JavaConstant)clazz, (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
            InvokeWithExceptionNode box = kit.boxObjectInLocalHandle((ValueNode)clazzNode);
            jniArguments.add((ValueNode)box);
            jniArgumentTypes.add((JavaType)objectHandleType);
        }
        for (int i = 0; i < javaArguments.size(); ++i) {
            ValueNode arg = javaArguments.get(i);
            JavaType argType = javaArgumentTypes[i];
            if (javaArgumentTypes[i].getJavaKind().isObject()) {
                ValueNode obj = javaArguments.get(i);
                arg = kit.boxObjectInLocalHandle(obj);
                argType = objectHandleType;
            }
            jniArguments.add(arg);
            jniArgumentTypes.add(argType);
        }
        assert (jniArguments.size() == jniArgumentTypes.size());
        JavaType jniReturnType = javaReturnType;
        if (jniReturnType.getJavaKind().isObject()) {
            jniReturnType = objectHandleType;
        }
        if (this.getOriginal().isSynchronized()) {
            ValueNode monitorObject;
            if (method.isStatic()) {
                Constant hubConstant = providers.getConstantReflection().asObjectHub(method.getDeclaringClass());
                DynamicHub hub = (DynamicHub)SubstrateObjectConstant.asObject(hubConstant);
                monitorObject = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(hub), (MetaAccessProvider)providers.getMetaAccess(), (StructuredGraph)graph);
            } else {
                monitorObject = kit.maybeCreateExplicitNullCheck(javaArguments.get(0));
            }
            MonitorIdNode monitorId = (MonitorIdNode)graph.add((Node)new MonitorIdNode(kit.getFrameState().lockDepth(false)));
            MonitorEnterNode monitorEnter = (MonitorEnterNode)kit.append((ValueNode)new MonitorEnterNode(monitorObject, monitorId));
            kit.getFrameState().pushLock(monitorEnter.object(), monitorEnter.getMonitorId());
            monitorEnter.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorEnter));
        }
        kit.getFrameState().clearLocals();
        SimpleSignature jniSignature = new SimpleSignature(jniArgumentTypes, jniReturnType);
        ValueNode returnValue = kit.createCFunctionCall((ValueNode)callAddress, jniArguments, jniSignature, 3, false);
        if (this.getOriginal().isSynchronized()) {
            MonitorIdNode monitorId = kit.getFrameState().peekMonitorId();
            ValueNode monitorObject = kit.getFrameState().popLock();
            MonitorExitNode monitorExit = (MonitorExitNode)kit.append((ValueNode)new MonitorExitNode(monitorObject, monitorId, null));
            monitorExit.setStateAfter(kit.getFrameState().create(kit.bci(), (StateSplit)monitorExit));
        }
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = kit.unboxHandle(returnValue);
        }
        kit.nativeCallEpilogue((ValueNode)handleFrame);
        kit.rethrowPendingException();
        if (javaReturnType.getJavaKind().isObject()) {
            returnValue = JNINativeCallWrapperMethod.castObject(kit, returnValue, (ResolvedJavaType)javaReturnType);
        }
        kit.createReturn(returnValue, javaReturnType.getJavaKind());
        return kit.finalizeGraph();
    }

    private static ValueNode castObject(JNIGraphKit kit, ValueNode object, ResolvedJavaType type) {
        TypeReference typeRef;
        LogicNode condition;
        ValueNode casted = object;
        if (!type.isJavaLangObject() && !(condition = (LogicNode)kit.append((ValueNode)InstanceOfNode.createAllowNull((TypeReference)(typeRef = TypeReference.createTrusted((Assumptions)kit.getAssumptions(), (ResolvedJavaType)type)), (ValueNode)object, null, null))).isTautology()) {
            ObjectStamp stamp = StampFactory.object((TypeReference)typeRef, (boolean)false);
            ConstantNode expectedClass = kit.createConstant((Constant)kit.getConstantReflection().asJavaClass(type), JavaKind.Object);
            GuardingNode guard = kit.createCheckThrowingBytecodeException(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{object, expectedClass});
            casted = kit.append(PiNode.create((ValueNode)object, (Stamp)stamp, (ValueNode)guard.asNode()));
        }
        return casted;
    }
}

