/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.SharedCodeCacheProvider;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.graal.isolated.IsolateAwareCodeCacheProvider;
import com.oracle.svm.graal.meta.SubstrateCodeCacheProvider;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateGraphMakerFactory;
import java.util.function.Function;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;

public class SubstrateRuntimeConfigurationBuilder
extends SharedRuntimeConfigurationBuilder {
    private final AnalysisUniverse aUniverse;
    private final ConstantReflectionProvider originalReflectionProvider;

    public SubstrateRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, AnalysisUniverse aUniverse, MetaAccessProvider metaAccess, ConstantReflectionProvider originalReflectionProvider, Function<Providers, SubstrateBackend> backendProvider, NativeLibraries nativeLibraries, ClassInitializationSupport classInitializationSupport, LoopsDataProvider loopsDataProvider) {
        super(options, hostVM, metaAccess, backendProvider, nativeLibraries, classInitializationSupport, loopsDataProvider);
        this.aUniverse = aUniverse;
        this.originalReflectionProvider = originalReflectionProvider;
    }

    @Override
    protected ConstantReflectionProvider createConstantReflectionProvider(Providers p) {
        return new AnalysisConstantReflectionProvider(this.aUniverse, this.metaAccess, this.originalReflectionProvider, this.classInitializationSupport);
    }

    @Override
    protected ConstantFieldProvider createConstantFieldProvider(Providers p) {
        return new AnalysisConstantFieldProvider(this.aUniverse, (AnalysisMetaAccess)p.getMetaAccess(), (AnalysisConstantReflectionProvider)p.getConstantReflection(), this.classInitializationSupport);
    }

    @Override
    protected Replacements createReplacements(Providers p, SnippetReflectionProvider snippetReflection) {
        ResolvedJavaMethodBytecodeProvider bytecodeProvider = new ResolvedJavaMethodBytecodeProvider();
        return new SubstrateReplacements(p, snippetReflection, (BytecodeProvider)bytecodeProvider, ConfigurationValues.getTarget(), this.wordTypes, new SubstrateGraphMakerFactory(this.wordTypes));
    }

    @Override
    protected SharedCodeCacheProvider createCodeCacheProvider(RegisterConfig registerConfig) {
        if (SubstrateOptions.supportCompileInIsolates()) {
            return new IsolateAwareCodeCacheProvider(ConfigurationValues.getTarget(), registerConfig);
        }
        return new SubstrateCodeCacheProvider(ConfigurationValues.getTarget(), registerConfig);
    }
}

