/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.windows.WindowsVMLockSupport;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.SynchAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordFactory;

public final class WindowsVMThreads
extends VMThreads {
    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public VMThreads.OSThreadHandle getCurrentOSThreadHandle() {
        WinBase.LPHANDLE pointerToResult;
        WinBase.HANDLE pseudoThreadHandle = Process.NoTransitions.GetCurrentThread();
        WinBase.HANDLE pseudoProcessHandle = Process.NoTransitions.GetCurrentProcess();
        int status = WinBase.DuplicateHandle(pseudoProcessHandle, pseudoThreadHandle, pseudoProcessHandle, pointerToResult = (WinBase.LPHANDLE)StackValue.get(WinBase.LPHANDLE.class), Process.SYNCHRONIZE(), false, 0);
        VMError.guarantee(status != 0, "Duplicating thread handle failed.");
        return (VMThreads.OSThreadHandle)((Object)pointerToResult.read());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected VMThreads.OSThreadId getCurrentOSThreadId() {
        return (VMThreads.OSThreadId)WordFactory.unsigned((int)Process.NoTransitions.GetCurrentThreadId());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.")
    protected void joinNoTransition(VMThreads.OSThreadHandle osThreadHandle) {
        WinBase.HANDLE handle = (WinBase.HANDLE)((Object)osThreadHandle);
        int status = SynchAPI.NoTransitions.WaitForSingleObject(handle, SynchAPI.INFINITE());
        VMError.guarantee(status == SynchAPI.WAIT_OBJECT_0(), "Joining thread failed.");
        status = WinBase.CloseHandle(handle);
        VMError.guarantee(status != 0, "Closing the thread handle failed.");
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void nativeSleep(int milliseconds) {
        SynchAPI.NoTransitions.Sleep(milliseconds);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void yield() {
        Process.NoTransitions.SwitchToThread();
    }

    @Override
    public boolean supportsPatientSafepoints() {
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    protected boolean initializeOnce() {
        WindowsVMLockSupport.initialize();
        return true;
    }

    @Override
    @Uninterruptible(reason="Thread state not set up.")
    public void failFatally(int code, CCharPointer message) {
        LibC.exit(code);
    }
}

