/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.SplittableRandomAccessors;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.IsolateThread;

public abstract class JavaVMOperation
extends VMOperation
implements VMOperationControl.JavaAllocationFreeQueue.Element<JavaVMOperation> {
    protected IsolateThread queuingThread;
    private JavaVMOperation next;
    private volatile boolean finished;

    protected JavaVMOperation(String name, VMOperation.SystemEffect systemEffect) {
        super(name, systemEffect);
        SplittableRandomAccessors.getDefaultGen();
        VMError.guarantee(!SubstrateUtil.HOSTED, "must not be created at image build time");
    }

    @Override
    public JavaVMOperation getNext() {
        return this.next;
    }

    @Override
    public void setNext(JavaVMOperation value) {
        this.next = value;
    }

    public void enqueue() {
        VMOperationControl.get().enqueue(this);
    }

    @Override
    protected IsolateThread getQueuingThread(NativeVMOperationData data) {
        return this.queuingThread;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setQueuingThread(NativeVMOperationData data, IsolateThread thread) {
        this.queuingThread = thread;
    }

    @Override
    protected boolean isFinished(NativeVMOperationData data) {
        return this.finished;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void setFinished(NativeVMOperationData data, boolean value) {
        this.finished = value;
    }

    @Override
    protected final boolean hasWork(NativeVMOperationData data) {
        return this.hasWork();
    }

    protected boolean hasWork() {
        return true;
    }

    public static void enqueueBlockingSafepoint(String name, SubstrateUtil.Thunk thunk) {
        ThunkOperation vmOperation = new ThunkOperation(name, VMOperation.SystemEffect.SAFEPOINT, thunk);
        vmOperation.enqueue();
    }

    public static void enqueueBlockingNoSafepoint(String name, SubstrateUtil.Thunk thunk) {
        ThunkOperation vmOperation = new ThunkOperation(name, VMOperation.SystemEffect.NONE, thunk);
        vmOperation.enqueue();
    }

    @Override
    public final void operate(NativeVMOperationData data) {
        this.operate();
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Whitelisted because some operations may allocate.")
    protected abstract void operate();

    public static class ThunkOperation
    extends JavaVMOperation {
        private SubstrateUtil.Thunk thunk;

        ThunkOperation(String name, VMOperation.SystemEffect systemEffect, SubstrateUtil.Thunk thunk) {
            super(name, systemEffect);
            this.thunk = thunk;
        }

        @Override
        public void operate() {
            this.thunk.invoke();
        }
    }
}

