/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.Pthread;
import com.oracle.svm.core.posix.headers.darwin.DarwinPthread;
import com.oracle.svm.core.stack.StackOverflowCheck;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class DarwinStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    DarwinStackOverflowSupport() {
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackBase() {
        Pthread.pthread_t self = Pthread.pthread_self();
        return DarwinPthread.pthread_get_stackaddr_np(self);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd() {
        return this.lookupStackEnd((UnsignedWord)WordFactory.zero());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public UnsignedWord lookupStackEnd(UnsignedWord requestedStackSize) {
        Pthread.pthread_t self = Pthread.pthread_self();
        Pointer stackaddr = DarwinPthread.pthread_get_stackaddr_np(self);
        UnsignedWord stacksize = DarwinPthread.pthread_get_stacksize_np(self);
        if (requestedStackSize.notEqual((UnsignedWord)WordFactory.zero()) && stacksize.aboveThan(requestedStackSize)) {
            return stackaddr.subtract(requestedStackSize);
        }
        return stackaddr.subtract(stacksize);
    }
}

