/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.meta;

import com.oracle.svm.core.annotate.ExplicitCallingConvention;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public interface SharedMethod
extends ResolvedJavaMethod {
    public boolean isEntryPoint();

    default public SubstrateCallingConventionKind getCallingConventionKind() {
        ExplicitCallingConvention explicitCallingConvention = (ExplicitCallingConvention)this.getAnnotation(ExplicitCallingConvention.class);
        if (explicitCallingConvention != null) {
            return explicitCallingConvention.value();
        }
        if (this.isEntryPoint()) {
            return SubstrateCallingConventionKind.Native;
        }
        return SubstrateCallingConventionKind.Java;
    }

    public boolean hasCalleeSavedRegisters();

    public SharedMethod[] getImplementations();

    public boolean isDeoptTarget();

    public boolean canDeoptimize();

    public int getVTableIndex();

    public Deoptimizer.StubType getDeoptStubType();

    public boolean hasCodeOffsetInImage();

    public int getCodeOffsetInImage();

    public int getDeoptOffsetInImage();
}

