/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.locks;

import com.oracle.svm.core.util.VMError;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public abstract class ClassInstanceReplacer<S, T>
implements Function<Object, Object> {
    private final Class<S> sourceClass;
    private final Map<S, T> replacements = Collections.synchronizedMap(new IdentityHashMap());
    private boolean sealed;

    protected ClassInstanceReplacer(Class<S> sourceClass) {
        this.sourceClass = sourceClass;
    }

    @Override
    public Object apply(Object object) {
        if (object == null || object.getClass() != this.sourceClass) {
            return object;
        }
        return this.replacements.computeIfAbsent(this.sourceClass.cast(object), this::doReplace);
    }

    private T doReplace(S object) {
        VMError.guarantee(!this.sealed, "new object introduced after static analysis");
        T replacement = this.createReplacement(object);
        assert (replacement.getClass() != this.sourceClass) : "leads to recursive replacement";
        return replacement;
    }

    public Collection<T> getReplacements() {
        this.sealed = true;
        return this.replacements.values();
    }

    protected abstract T createReplacement(S var1);
}

