/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.heap.ReferenceMapEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodeReferenceMapEncoder
extends ReferenceMapEncoder {
    @Override
    protected void encodeAll(List<Map.Entry<ReferenceMapEncoder.Input, Long>> sortedEntries) {
        assert (0L == this.writeBuffer.getBytesWritten());
        this.encodeEndOfTable();
        for (Map.Entry<ReferenceMapEncoder.Input, Long> entry : sortedEntries) {
            ReferenceMapEncoder.Input map = entry.getKey();
            this.encodings.put(map, this.encode(map.getOffsets()));
        }
    }

    private long encode(ReferenceMapEncoder.OffsetIterator offsets) {
        int compressedSize = ConfigurationValues.getObjectLayout().getReferenceSize();
        int uncompressedSize = FrameAccess.uncompressedReferenceSize();
        long startIndex = this.writeBuffer.getBytesWritten();
        int run = 0;
        int gap = 0;
        boolean firstRun = true;
        boolean expectedCompressed = false;
        int expectedOffset = 0;
        while (offsets.hasNext()) {
            int size;
            boolean compressed = offsets.isNextCompressed();
            boolean derived = offsets.isNextDerived();
            int offset = offsets.nextInt();
            if (offset == expectedOffset && compressed == expectedCompressed && !derived) {
                ++run;
            } else {
                assert (firstRun || offset >= expectedOffset) : "values must be strictly increasing";
                if (run > 0) {
                    this.encodeRun(firstRun, gap, run, expectedCompressed, false);
                    firstRun = false;
                }
                gap = offset - expectedOffset;
                run = 1;
            }
            int n = size = compressed ? compressedSize : uncompressedSize;
            if (derived) {
                this.encodeDerivedRun(firstRun, gap, offset, offsets.getDerivedOffsets(offset), compressed, size);
                firstRun = false;
                run = 0;
                gap = 0;
            }
            expectedOffset = offset + size;
            expectedCompressed = compressed;
        }
        if (run > 0) {
            this.encodeRun(firstRun, gap, run, expectedCompressed, false);
        }
        this.encodeEndOfTable();
        return startIndex;
    }

    private void encodeRun(boolean firstRun, int gap, int refsCount, boolean compressed, boolean derived) {
        if (firstRun && derived) {
            this.encodeRun(true, -1, 0, false, false);
            this.encodeRun(false, gap + 1, refsCount, compressed, derived);
            return;
        }
        assert (firstRun || gap >= 0);
        assert (!compressed ? refsCount >= 0 : refsCount > 0);
        this.writeBuffer.putSV(derived ? (long)(-gap - 1) : (long)gap);
        this.writeBuffer.putSV(compressed ? (long)(-refsCount) : (long)refsCount);
    }

    private void encodeDerivedRun(boolean firstRun, int gap, int baseOffset, Set<Integer> derivedOffsets, boolean compressed, int size) {
        this.encodeRun(firstRun, gap, derivedOffsets.size(), compressed, true);
        for (int derivedOffset : derivedOffsets) {
            assert (baseOffset % size == 0 && derivedOffset % size == 0 && derivedOffset != baseOffset);
            this.writeBuffer.putSV((long)((derivedOffset - baseOffset) / size));
        }
    }

    private void encodeEndOfTable() {
        this.writeBuffer.putSV(0L);
        this.writeBuffer.putSV(0L);
    }
}

