/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.handles;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import java.util.Arrays;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

public final class ThreadLocalHandles<T extends ObjectHandle> {
    private static final int INITIAL_NUMBER_OF_FRAMES = 4;
    public static final int MIN_VALUE = Math.toIntExact(1L + ThreadLocalHandles.nullHandle().rawValue());
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    private Object[] objects;
    private int top = MIN_VALUE;
    private int[] frameStack = new int[4];
    private int frameCount = 0;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <U extends SignedWord> U nullHandle() {
        return (U)WordFactory.signed((int)0);
    }

    public static <U extends ObjectHandle> boolean isInRange(U handle) {
        return handle.rawValue() >= (long)MIN_VALUE && handle.rawValue() <= Integer.MAX_VALUE;
    }

    public ThreadLocalHandles(int initialNumberOfHandles) {
        this.objects = new Object[MIN_VALUE + initialNumberOfHandles];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends ObjectHandle> int toIndex(T handle) {
        return (int)handle.rawValue();
    }

    public int getHandleCount() {
        return this.top - MIN_VALUE;
    }

    public int pushFrame(int capacity) {
        if (this.frameCount == this.frameStack.length) {
            this.growFrameStack();
        }
        this.frameStack[this.frameCount] = this.top;
        ++this.frameCount;
        this.ensureCapacity(capacity);
        return this.frameCount;
    }

    @NeverInline(value="Decrease code size of JNI entry points by not inlining allocations")
    private void growFrameStack() {
        this.frameStack = Arrays.copyOf(this.frameStack, this.frameStack.length * 2);
    }

    public T create(Object obj) {
        if (obj == null) {
            return (T)((ObjectHandle)ThreadLocalHandles.nullHandle());
        }
        this.ensureCapacity(1);
        int index = this.top++;
        this.objects[index] = obj;
        return (T)((ObjectHandle)WordFactory.signed((int)index));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public <U> U getObject(T handle) {
        return (U)this.objects[ThreadLocalHandles.toIndex(handle)];
    }

    public boolean delete(T handle) {
        int index = ThreadLocalHandles.toIndex(handle);
        Object previous = this.objects[index];
        this.objects[index] = null;
        return previous != null;
    }

    public void popFrame() {
        this.popFramesIncluding(this.frameCount);
    }

    public void popFramesIncluding(int frame) {
        assert (frame > 0 && frame <= this.frameCount);
        int previousTop = this.top;
        this.frameCount = frame - 1;
        for (int i = this.top = this.frameStack[this.frameCount]; i < previousTop; ++i) {
            this.objects[i] = null;
        }
    }

    public void ensureCapacity(int capacity) {
        int minLength = this.top + capacity;
        if (minLength >= this.objects.length) {
            this.growCapacity(minLength);
        }
    }

    @NeverInline(value="Decrease code size of JNI entry points by not inlining allocations")
    private void growCapacity(int minLength) {
        this.objects = Arrays.copyOf(this.objects, minLength * 2);
    }
}

