/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class FloatingWordCastNode
extends FloatingNode
implements LIRLowerable,
Canonicalizable {
    public static final NodeClass<FloatingWordCastNode> TYPE = NodeClass.create(FloatingWordCastNode.class);
    @Node.Input
    protected ValueNode input;

    public FloatingWordCastNode(Stamp stamp, ValueNode input) {
        super(TYPE, stamp);
        this.input = input;
    }

    public Node canonical(CanonicalizerTool tool) {
        if (this.hasNoUsages()) {
            return this.input;
        }
        return this;
    }

    public void generate(NodeLIRBuilderTool generator) {
        Value value = generator.operand((Node)this.input);
        LIRKind kind = generator.getLIRGeneratorTool().getLIRKind(this.stamp(NodeView.DEFAULT));
        assert (kind.getPlatformKind().getSizeInBytes() == value.getPlatformKind().getSizeInBytes());
        if (kind.equals(value.getValueKind())) {
            generator.setResult((ValueNode)this, value);
        } else {
            Variable result = generator.getLIRGeneratorTool().newVariable((ValueKind)kind);
            generator.getLIRGeneratorTool().emitMove((AllocatableValue)result, value);
            generator.setResult((ValueNode)this, (Value)result);
        }
    }
}

