/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.VMError;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyLookup;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;

public class SubstrateForeignCallsProvider
implements ArrayCopyForeignCalls {
    final MetaAccessProvider metaAccess;
    final RegisterConfig registerConfig;
    final TargetDescription target;
    private final Map<ForeignCallSignature, SubstrateForeignCallLinkage> foreignCalls;
    protected ArrayCopyLookup arrayCopyLookup;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateForeignCallsProvider(MetaAccessProvider metaAccess, RegisterConfig registerConfig) {
        this.metaAccess = metaAccess;
        this.registerConfig = registerConfig;
        this.target = ConfigurationValues.getTarget();
        this.foreignCalls = new HashMap<ForeignCallSignature, SubstrateForeignCallLinkage>();
    }

    public Map<ForeignCallSignature, SubstrateForeignCallLinkage> getForeignCalls() {
        return this.foreignCalls;
    }

    public void register(SnippetRuntime.SubstrateForeignCallDescriptor ... descriptors) {
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : descriptors) {
            SubstrateForeignCallLinkage linkage = new SubstrateForeignCallLinkage(this, descriptor);
            this.foreignCalls.put(descriptor.getSignature(), linkage);
        }
    }

    public SubstrateForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        SubstrateForeignCallLinkage callTarget = this.foreignCalls.get(descriptor.getSignature());
        if (callTarget == null) {
            throw VMError.shouldNotReachHere("missing implementation for runtime call: " + descriptor);
        }
        return callTarget;
    }

    public ForeignCallDescriptor getDescriptor(ForeignCallSignature signature) {
        SubstrateForeignCallLinkage linkage = this.foreignCalls.get(signature);
        return linkage.getDescriptor();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind((Architecture)this.target.arch, (JavaKind)javaKind);
    }

    public void registerArrayCopyForeignCallsDelegate(ArrayCopyLookup arraycopyForeignCalls) {
        this.arrayCopyLookup = arraycopyForeignCalls;
    }

    public ForeignCallDescriptor lookupArraycopyDescriptor(JavaKind kind, boolean aligned, boolean disjoint, boolean uninit, LocationIdentity killedLocation) {
        if (this.arrayCopyLookup != null) {
            return this.arrayCopyLookup.lookupArraycopyDescriptor(kind, aligned, disjoint, uninit, killedLocation);
        }
        throw VMError.unsupportedFeature("Fast ArrayCopy not supported yet.");
    }
}

