/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.VMOperation;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

final class MemoryWalkerImpl
extends MemoryWalker {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    MemoryWalkerImpl() {
    }

    @Override
    public boolean visitMemory(MemoryWalker.Visitor visitor) {
        MemoryWalkerVMOperation op = new MemoryWalkerVMOperation(visitor);
        op.enqueue();
        return op.getResult();
    }

    static final class MemoryWalkerVMOperation
    extends JavaVMOperation {
        private final MemoryWalker.Visitor visitor;
        private boolean result = false;

        MemoryWalkerVMOperation(MemoryWalker.Visitor memoryVisitor) {
            super("MemoryWalkerImpl.visitMemory", VMOperation.SystemEffect.SAFEPOINT);
            this.visitor = memoryVisitor;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Allocation would change the memory being visited.")
        public void operate() {
            ThreadLocalAllocation.disableAndFlushForAllThreads();
            this.result = HeapImpl.getHeapImpl().walkMemory(this.visitor) && CodeInfoTable.getImageCodeCache().walkImageCode(this.visitor) && CodeInfoTable.getRuntimeCodeCache().walkRuntimeMethods(this.visitor);
        }

        boolean getResult() {
            return this.result;
        }
    }
}

