/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;

public class SubstrateSpeculationLog
implements SpeculationLog {
    private Map<SpeculationLog.SpeculationReason, Boolean> failedSpeculations;
    private volatile LogEntry addedFailedSpeculationsHead;
    private static final AtomicReferenceFieldUpdater<SubstrateSpeculationLog, LogEntry> HEAD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SubstrateSpeculationLog.class, LogEntry.class, "addedFailedSpeculationsHead");

    public void addFailedSpeculation(SpeculationLog.SpeculationReason speculation) {
        LogEntry newHead;
        LogEntry oldHead;
        while (!HEAD_UPDATER.compareAndSet(this, oldHead = this.addedFailedSpeculationsHead, newHead = new LogEntry(speculation, oldHead))) {
        }
    }

    public synchronized void collectFailedSpeculations() {
        LogEntry cur = HEAD_UPDATER.getAndSet(this, null);
        while (cur != null) {
            if (this.failedSpeculations == null) {
                this.failedSpeculations = new HashMap<SpeculationLog.SpeculationReason, Boolean>();
            }
            this.failedSpeculations.put(cur.reason, Boolean.TRUE);
            cur = cur.next;
        }
    }

    public synchronized boolean maySpeculate(SpeculationLog.SpeculationReason reason) {
        return this.failedSpeculations == null || !this.failedSpeculations.containsKey(reason);
    }

    public SpeculationLog.Speculation speculate(SpeculationLog.SpeculationReason reason) {
        return new SubstrateSpeculation(reason);
    }

    public boolean hasSpeculations() {
        return true;
    }

    public SpeculationLog.Speculation lookupSpeculation(JavaConstant constant) {
        return new SubstrateSpeculation((SpeculationLog.SpeculationReason)SubstrateObjectConstant.asObject((Constant)constant));
    }

    private static final class LogEntry {
        private final SpeculationLog.SpeculationReason reason;
        private final LogEntry next;

        private LogEntry(SpeculationLog.SpeculationReason reason, LogEntry next) {
            this.reason = reason;
            this.next = next;
        }
    }

    public static final class SubstrateSpeculation
    extends SpeculationLog.Speculation {
        public SubstrateSpeculation(SpeculationLog.SpeculationReason reason) {
            super(reason);
        }
    }
}

