/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.util.json.JSONParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public abstract class ConfigurationParser {
    public static final String CONDITIONAL_KEY = "condition";
    public static final String TYPE_REACHABLE_KEY = "typeReachable";
    private final Map<String, Set<String>> seenUnknownAttributesByType = new HashMap<String, Set<String>>();
    private final boolean strictConfiguration;

    protected ConfigurationParser(boolean strictConfiguration) {
        this.strictConfiguration = strictConfiguration;
    }

    public void parseAndRegister(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            this.parseAndRegister(reader);
        }
    }

    public abstract void parseAndRegister(Reader var1) throws IOException;

    protected static List<Object> asList(Object data, String errorMessage) {
        if (data instanceof List) {
            return (List)data;
        }
        throw new JSONParserException(errorMessage);
    }

    protected static Map<String, Object> asMap(Object data, String errorMessage) {
        if (data instanceof Map) {
            return (Map)data;
        }
        throw new JSONParserException(errorMessage);
    }

    protected void checkAttributes(Map<String, Object> map, String type, Collection<String> requiredAttrs, Collection<String> optionalAttrs) {
        HashSet<String> unseenRequired = new HashSet<String>(requiredAttrs);
        unseenRequired.removeAll(map.keySet());
        if (!unseenRequired.isEmpty()) {
            throw new JSONParserException("Missing attribute(s) [" + String.join((CharSequence)", ", unseenRequired) + "] in " + type);
        }
        HashSet<String> unknownAttributes = new HashSet<String>(map.keySet());
        unknownAttributes.removeAll(requiredAttrs);
        unknownAttributes.removeAll(optionalAttrs);
        if (this.seenUnknownAttributesByType.containsKey(type)) {
            unknownAttributes.removeAll((Collection)this.seenUnknownAttributesByType.get(type));
        }
        if (unknownAttributes.size() > 0) {
            String message = "Unknown attribute(s) [" + String.join((CharSequence)", ", unknownAttributes) + "] in " + type;
            this.warnOrFail(message);
            Set unknownAttributesForType = this.seenUnknownAttributesByType.computeIfAbsent(type, key -> new HashSet());
            unknownAttributesForType.addAll(unknownAttributes);
        }
    }

    protected void warnOrFail(String message) {
        if (this.strictConfiguration) {
            throw new JSONParserException(message);
        }
        System.err.println("Warning: " + message);
    }

    protected void checkAttributes(Map<String, Object> map, String type, Collection<String> requiredAttrs) {
        this.checkAttributes(map, type, requiredAttrs, Collections.emptyList());
    }

    protected static String asString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\".");
    }

    protected static String asString(Object value, String propertyName) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new JSONParserException("Invalid string value \"" + value + "\" for element '" + propertyName + "'");
    }

    protected static String asNullableString(Object value, String propertyName) {
        return value == null ? null : ConfigurationParser.asString(value, propertyName);
    }

    protected static boolean asBoolean(Object value, String propertyName) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new JSONParserException("Invalid boolean value '" + value + "' for element '" + propertyName + "'");
    }

    protected static long asLong(Object value, String propertyName) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        throw new JSONParserException("Invalid long value '" + value + "' for element '" + propertyName + "'");
    }

    protected ConfigurationCondition parseCondition(Map<String, Object> data) {
        Object conditionData = data.get(CONDITIONAL_KEY);
        if (conditionData != null) {
            Map<String, Object> conditionObject = ConfigurationParser.asMap(conditionData, "Attribute 'condition' must be an object");
            Object conditionType = conditionObject.get(TYPE_REACHABLE_KEY);
            if (conditionType instanceof String) {
                return ConfigurationCondition.create((String)((String)conditionType));
            }
            this.warnOrFail("'typeReachable' should be of type string");
        }
        return ConfigurationCondition.alwaysTrue();
    }
}

