/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.CErrorNumber;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.truffle.nfi.ErrnoMirror;
import com.oracle.svm.truffle.nfi.LibFFI;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_ClosureNativePointer;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIClosure_RetPatches;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFISignature;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType_CachedTypeInfo;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType_EnvType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType_NullableType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType_ObjectType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_LibFFIType_StringType;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIContext;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NativeString;
import com.oracle.svm.truffle.nfi.TruffleNFISupport;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.svm.truffle.nfi.libffi.LibFFI;
import com.oracle.truffle.api.CallTarget;
import java.nio.ByteBuffer;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class NativeClosure {
    private final CallTarget callTarget;
    private final Target_com_oracle_truffle_nfi_impl_LibFFISignature signature;
    static final FastThreadLocalObject<Throwable> pendingException = FastThreadLocalFactory.createObject(Throwable.class);
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_BUFFER_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureBufferRet", (Class[])new Class[]{LibFFI.ffi_cif.class, Pointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_VOID_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureVoidRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_STRING_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureStringRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});
    static final CEntryPointLiteral<LibFFI.ffi_closure_callback> INVOKE_CLOSURE_OBJECT_RET = CEntryPointLiteral.create(NativeClosure.class, (String)"invokeClosureObjectRet", (Class[])new Class[]{LibFFI.ffi_cif.class, WordPointer.class, WordPointer.class, LibFFI.ClosureData.class});

    private NativeClosure(CallTarget callTarget, Target_com_oracle_truffle_nfi_impl_LibFFISignature signature) {
        this.callTarget = callTarget;
        this.signature = signature;
    }

    private ByteBuffer createRetBuffer(PointerBase buffer) {
        Target_com_oracle_truffle_nfi_impl_LibFFIType_CachedTypeInfo retType = this.signature.signatureInfo.getRetType();
        int size = retType.size;
        if (size < SizeOf.get(LibFFI.ffi_arg.class)) {
            size = SizeOf.get(LibFFI.ffi_arg.class);
        }
        return CTypeConversion.asByteBuffer((PointerBase)buffer, (int)size);
    }

    static Target_com_oracle_truffle_nfi_impl_ClosureNativePointer prepareClosure(Target_com_oracle_truffle_nfi_impl_NFIContext ctx, Target_com_oracle_truffle_nfi_impl_LibFFISignature signature, CallTarget callTarget, LibFFI.ffi_closure_callback callback) {
        NativeClosure closure = new NativeClosure(callTarget, signature);
        LibFFI.NativeClosureHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createClosureHandle(closure);
        WordPointer codePtr = (WordPointer)StackValue.get(WordPointer.class);
        LibFFI.ClosureData data = (LibFFI.ClosureData)LibFFI.ffi_closure_alloc(SizeOf.unsigned(LibFFI.ClosureData.class), codePtr);
        data.setNativeClosureHandle(handle);
        data.setIsolate(CurrentIsolate.getIsolate());
        PointerBase code = (PointerBase)codePtr.read();
        LibFFI.ffi_prep_closure_loc(data.ffiClosure(), (LibFFI.ffi_cif)WordFactory.pointer((long)signature.cif), callback, (WordBase)data, code);
        return ctx.createClosureNativePointer(data.rawValue(), code.rawValue(), callTarget, signature);
    }

    private Object call(WordPointer argPointers, ByteBuffer retBuffer) {
        Target_com_oracle_truffle_nfi_impl_LibFFIType_CachedTypeInfo[] argTypes = this.signature.signatureInfo.getArgTypes();
        int length = argTypes.length;
        if (retBuffer != null) {
            ++length;
        }
        Object[] args = new Object[length];
        for (int i = 0; i < argTypes.length; ++i) {
            CCharPointerPointer argPtr;
            Target_com_oracle_truffle_nfi_impl_LibFFIType_CachedTypeInfo type = argTypes[i];
            if (Target_com_oracle_truffle_nfi_impl_LibFFIType_StringType.class.isInstance(type)) {
                argPtr = (CCharPointerPointer)argPointers.read(i);
                args[i] = TruffleNFISupport.utf8ToJavaString(argPtr.read());
                continue;
            }
            if (Target_com_oracle_truffle_nfi_impl_LibFFIType_ObjectType.class.isInstance(type)) {
                argPtr = (WordPointer)argPointers.read(i);
                args[i] = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveHandle((TruffleObjectHandle)argPtr.read());
                continue;
            }
            if (Target_com_oracle_truffle_nfi_impl_LibFFIType_NullableType.class.isInstance(type)) {
                argPtr = (WordPointer)argPointers.read(i);
                args[i] = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveHandle((TruffleObjectHandle)argPtr.read());
                continue;
            }
            if (Target_com_oracle_truffle_nfi_impl_LibFFIType_EnvType.class.isInstance(type)) continue;
            argPtr = (WordPointer)argPointers.read(i);
            args[i] = CTypeConversion.asByteBuffer((PointerBase)argPtr, (int)argTypes[i].size);
        }
        if (retBuffer != null) {
            args[argTypes.length] = retBuffer;
        }
        return this.callTarget.call(args);
    }

    private static NativeClosure lookup(LibFFI.ClosureData data) {
        return ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).resolveClosureHandle(data.nativeClosureHandle());
    }

    private static PointerBase serializeStringRet(Object retValue) {
        if (retValue == null) {
            return (PointerBase)WordFactory.zero();
        }
        if (retValue instanceof Target_com_oracle_truffle_nfi_impl_NativeString) {
            Target_com_oracle_truffle_nfi_impl_NativeString nativeString = (Target_com_oracle_truffle_nfi_impl_NativeString)retValue;
            return WordFactory.pointer((long)nativeString.nativePointer);
        }
        if (retValue instanceof String) {
            byte[] utf8 = TruffleNFISupport.javaStringToUtf8((String)retValue);
            try (PinnedObject pinned = PinnedObject.create((Object)utf8);){
                CCharPointer source = (CCharPointer)pinned.addressOfArrayElement(0);
                CCharPointer cCharPointer = TruffleNFISupport.strdup(source);
                return cCharPointer;
            }
        }
        return (PointerBase)WordFactory.zero();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureBufferRet(LibFFI.ffi_cif cif, Pointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = CErrorNumber.getCErrorNumber();
        CEntryPointActions.enterIsolate(user.isolate());
        ErrnoMirror.errnoMirror.getAddress().write(errno);
        try {
            NativeClosure.doInvokeClosureBufferRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set(t);
        }
        errno = ErrnoMirror.errnoMirror.getAddress().read();
        CEntryPointActions.leave();
        CErrorNumber.setCErrorNumber(errno);
    }

    private static void doInvokeClosureBufferRet(Pointer ret, WordPointer args, LibFFI.ClosureData user) {
        ByteBuffer retBuffer;
        NativeClosure closure = NativeClosure.lookup(user);
        Target_com_oracle_truffle_nfi_impl_LibFFIClosure_RetPatches patches = (Target_com_oracle_truffle_nfi_impl_LibFFIClosure_RetPatches)closure.call(args, retBuffer = closure.createRetBuffer((PointerBase)ret));
        if (patches != null) {
            for (int i = 0; i < patches.count; ++i) {
                Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag tag = Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.getTag(patches.patches[i]);
                int offset = Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.getOffset(patches.patches[i]);
                Object obj = patches.objects[i];
                if (tag == Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.OBJECT) {
                    TruffleObjectHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createGlobalHandle(obj);
                    ret.writeWord(offset, (WordBase)handle);
                    continue;
                }
                if (tag != Target_com_oracle_truffle_nfi_impl_NativeArgumentBuffer_TypeTag.STRING) continue;
                ret.writeWord(offset, (WordBase)NativeClosure.serializeStringRet(obj));
            }
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureVoidRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = CErrorNumber.getCErrorNumber();
        CEntryPointActions.enterIsolate(user.isolate());
        ErrnoMirror.errnoMirror.getAddress().write(errno);
        try {
            NativeClosure.doInvokeClosureVoidRet(args, user);
        }
        catch (Throwable t) {
            pendingException.set(t);
        }
        errno = ErrnoMirror.errnoMirror.getAddress().read();
        CEntryPointActions.leave();
        CErrorNumber.setCErrorNumber(errno);
    }

    private static void doInvokeClosureVoidRet(WordPointer args, LibFFI.ClosureData user) {
        NativeClosure.lookup(user).call(args, null);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureStringRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = CErrorNumber.getCErrorNumber();
        CEntryPointActions.enterIsolate(user.isolate());
        ErrnoMirror.errnoMirror.getAddress().write(errno);
        try {
            NativeClosure.doInvokeClosureStringRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set(t);
        }
        errno = ErrnoMirror.errnoMirror.getAddress().read();
        CEntryPointActions.leave();
        CErrorNumber.setCErrorNumber(errno);
    }

    private static void doInvokeClosureStringRet(WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        Object retValue = NativeClosure.lookup(user).call(args, null);
        ret.write((WordBase)NativeClosure.serializeStringRet(retValue));
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    @Uninterruptible(reason="contains prologue and epilogue for thread state transition", calleeMustBe=false)
    static void invokeClosureObjectRet(LibFFI.ffi_cif cif, WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        int errno = CErrorNumber.getCErrorNumber();
        CEntryPointActions.enterIsolate(user.isolate());
        ErrnoMirror.errnoMirror.getAddress().write(errno);
        try {
            NativeClosure.doInvokeClosureObjectRet(ret, args, user);
        }
        catch (Throwable t) {
            pendingException.set(t);
        }
        errno = ErrnoMirror.errnoMirror.getAddress().read();
        CEntryPointActions.leave();
        CErrorNumber.setCErrorNumber(errno);
    }

    private static void doInvokeClosureObjectRet(WordPointer ret, WordPointer args, LibFFI.ClosureData user) {
        Object obj = NativeClosure.lookup(user).call(args, null);
        if (obj == null) {
            ret.write(WordFactory.zero());
        } else {
            TruffleObjectHandle handle = ((TruffleNFISupport)ImageSingletons.lookup(TruffleNFISupport.class)).createGlobalHandle(obj);
            ret.write((WordBase)handle);
        }
    }
}

