/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.phases.ExperimentalNativeImageInlineDuringParsingPlugin;
import java.util.concurrent.ConcurrentHashMap;

public class ExperimentalNativeImageInlineDuringParsingSupport {
    private boolean nativeImageInlineDuringParsingDisabled;
    final ConcurrentHashMap<ExperimentalNativeImageInlineDuringParsingPlugin.CallSite, ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult> inlineData = new ConcurrentHashMap();

    public void disableNativeImageInlineDuringParsing() {
        this.nativeImageInlineDuringParsingDisabled = true;
    }

    public boolean isNativeImageInlineDuringParsingDisabled() {
        return this.nativeImageInlineDuringParsingDisabled;
    }

    void add(ExperimentalNativeImageInlineDuringParsingPlugin.CallSite callSite, ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult value) {
        ExperimentalNativeImageInlineDuringParsingPlugin.InvocationResult existingResult = this.inlineData.putIfAbsent(callSite, value);
        VMError.guarantee(existingResult == null, "Duplicate bci found during inlining in analysis. This is not supported. Please find the cause of the bci duplication and filtered it out.");
    }
}

