/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.nativeimage.ImageSingletons;

public class MaterializedConstantFields {
    private final Set<AnalysisField> fields = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean sealed = false;

    static void initialize() {
        ImageSingletons.add(MaterializedConstantFields.class, (Object)new MaterializedConstantFields());
    }

    public static MaterializedConstantFields singleton() {
        return (MaterializedConstantFields)ImageSingletons.lookup(MaterializedConstantFields.class);
    }

    public void register(AnalysisField field) {
        assert (field.isStatic() && field.isFinal()) : "Only required for static final fields";
        assert (field.isAccessed()) : "Field must be accessed as read";
        assert (!this.sealed) : "Already sealed";
        this.fields.add(field);
    }

    public boolean contains(AnalysisField field) {
        if (field.isStatic() && field.isFinal()) {
            return this.fields.contains(field);
        }
        return false;
    }

    void seal() {
        this.sealed = true;
    }
}

