/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import java.util.function.IntSupplier;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class FastThreadLocalFactory {
    private FastThreadLocalFactory() {
    }

    public static FastThreadLocalInt createInt() {
        return new FastThreadLocalInt();
    }

    public static FastThreadLocalLong createLong() {
        return new FastThreadLocalLong();
    }

    public static <T extends WordBase> FastThreadLocalWord<T> createWord() {
        return new FastThreadLocalWord();
    }

    public static <T> FastThreadLocalObject<T> createObject(Class<T> valueClass) {
        return new FastThreadLocalObject<T>(valueClass);
    }

    public static <T extends PointerBase> FastThreadLocalBytes<T> createBytes(IntSupplier sizeSupplier) {
        return new FastThreadLocalBytes(sizeSupplier);
    }
}

