/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.amd64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class AMD64UContextRegisterDumper
implements UContextRegisterDumper {
    AMD64UContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        RegisterDumper.dumpReg(log, "RAX ", gregs.read(Signal.GregEnum.REG_RAX.getCValue()));
        RegisterDumper.dumpReg(log, "RBX ", gregs.read(Signal.GregEnum.REG_RBX.getCValue()));
        RegisterDumper.dumpReg(log, "RCX ", gregs.read(Signal.GregEnum.REG_RCX.getCValue()));
        RegisterDumper.dumpReg(log, "RDX ", gregs.read(Signal.GregEnum.REG_RDX.getCValue()));
        RegisterDumper.dumpReg(log, "RBP ", gregs.read(Signal.GregEnum.REG_RBP.getCValue()));
        RegisterDumper.dumpReg(log, "RSI ", gregs.read(Signal.GregEnum.REG_RSI.getCValue()));
        RegisterDumper.dumpReg(log, "RDI ", gregs.read(Signal.GregEnum.REG_RDI.getCValue()));
        RegisterDumper.dumpReg(log, "RSP ", gregs.read(Signal.GregEnum.REG_RSP.getCValue()));
        RegisterDumper.dumpReg(log, "R8  ", gregs.read(Signal.GregEnum.REG_R8.getCValue()));
        RegisterDumper.dumpReg(log, "R9  ", gregs.read(Signal.GregEnum.REG_R9.getCValue()));
        RegisterDumper.dumpReg(log, "R10 ", gregs.read(Signal.GregEnum.REG_R10.getCValue()));
        RegisterDumper.dumpReg(log, "R11 ", gregs.read(Signal.GregEnum.REG_R11.getCValue()));
        RegisterDumper.dumpReg(log, "R12 ", gregs.read(Signal.GregEnum.REG_R12.getCValue()));
        RegisterDumper.dumpReg(log, "R13 ", gregs.read(Signal.GregEnum.REG_R13.getCValue()));
        RegisterDumper.dumpReg(log, "R14 ", gregs.read(Signal.GregEnum.REG_R14.getCValue()));
        RegisterDumper.dumpReg(log, "R15 ", gregs.read(Signal.GregEnum.REG_R15.getCValue()));
        RegisterDumper.dumpReg(log, "EFL ", gregs.read(Signal.GregEnum.REG_EFL.getCValue()));
        RegisterDumper.dumpReg(log, "RIP ", gregs.read(Signal.GregEnum.REG_RIP.getCValue()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_R14.getCValue()));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true, calleeMustBe=false)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_R15.getCValue()));
    }

    @Override
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_RSP.getCValue()));
    }

    @Override
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.GregsPointer gregs = uContext.uc_mcontext_gregs();
        return WordFactory.pointer((long)gregs.read(Signal.GregEnum.REG_RIP.getCValue()));
    }
}

