/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.aarch64;

import com.oracle.svm.core.RegisterDumper;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.posix.UContextRegisterDumper;
import com.oracle.svm.core.posix.headers.Signal;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class AArch64UContextRegisterDumper
implements UContextRegisterDumper {
    AArch64UContextRegisterDumper() {
    }

    @Override
    public void dumpRegisters(Log log, Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        Signal.GregsPointer regs = sigcontext.regs();
        RegisterDumper.dumpReg(log, "R0  ", regs.read(0));
        RegisterDumper.dumpReg(log, "R1  ", regs.read(1));
        RegisterDumper.dumpReg(log, "R2  ", regs.read(2));
        RegisterDumper.dumpReg(log, "R3  ", regs.read(3));
        RegisterDumper.dumpReg(log, "R4  ", regs.read(4));
        RegisterDumper.dumpReg(log, "R5  ", regs.read(5));
        RegisterDumper.dumpReg(log, "R6  ", regs.read(6));
        RegisterDumper.dumpReg(log, "R7  ", regs.read(7));
        RegisterDumper.dumpReg(log, "R8  ", regs.read(8));
        RegisterDumper.dumpReg(log, "R9  ", regs.read(9));
        RegisterDumper.dumpReg(log, "R10 ", regs.read(10));
        RegisterDumper.dumpReg(log, "R11 ", regs.read(11));
        RegisterDumper.dumpReg(log, "R12 ", regs.read(12));
        RegisterDumper.dumpReg(log, "R13 ", regs.read(13));
        RegisterDumper.dumpReg(log, "R14 ", regs.read(14));
        RegisterDumper.dumpReg(log, "R15 ", regs.read(15));
        RegisterDumper.dumpReg(log, "R16 ", regs.read(16));
        RegisterDumper.dumpReg(log, "R17 ", regs.read(17));
        RegisterDumper.dumpReg(log, "R18 ", regs.read(18));
        RegisterDumper.dumpReg(log, "R19 ", regs.read(19));
        RegisterDumper.dumpReg(log, "R20 ", regs.read(20));
        RegisterDumper.dumpReg(log, "R21 ", regs.read(21));
        RegisterDumper.dumpReg(log, "R22 ", regs.read(22));
        RegisterDumper.dumpReg(log, "R23 ", regs.read(23));
        RegisterDumper.dumpReg(log, "R24 ", regs.read(24));
        RegisterDumper.dumpReg(log, "R25 ", regs.read(25));
        RegisterDumper.dumpReg(log, "R26 ", regs.read(26));
        RegisterDumper.dumpReg(log, "R27 ", regs.read(27));
        RegisterDumper.dumpReg(log, "R28 ", regs.read(28));
        RegisterDumper.dumpReg(log, "R29 ", regs.read(29));
        RegisterDumper.dumpReg(log, "R30 ", regs.read(30));
        RegisterDumper.dumpReg(log, "R31 ", regs.read(31));
        RegisterDumper.dumpReg(log, "SP  ", sigcontext.sp());
        RegisterDumper.dumpReg(log, "PC  ", sigcontext.pc());
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getHeapBase(Signal.ucontext_t uContext) {
        Signal.GregsPointer regs = uContext.uc_mcontext().regs();
        return WordFactory.pointer((long)regs.read(27));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code", mayBeInlined=true)
    public PointerBase getThreadPointer(Signal.ucontext_t uContext) {
        Signal.GregsPointer regs = uContext.uc_mcontext().regs();
        return WordFactory.pointer((long)regs.read(28));
    }

    @Override
    public PointerBase getSP(Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        return WordFactory.pointer((long)sigcontext.sp());
    }

    @Override
    public PointerBase getIP(Signal.ucontext_t uContext) {
        Signal.mcontext_t sigcontext = uContext.uc_mcontext();
        return WordFactory.pointer((long)sigcontext.pc());
    }
}

