/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.posix.Target_java_io_FilterInputStream;
import com.oracle.svm.core.posix.Target_sun_security_provider_NativePRNG;
import com.oracle.svm.core.posix.Target_sun_security_provider_NativePRNG_RandomIO;
import java.io.Closeable;
import java.io.FilterInputStream;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
class NativeSecureRandomFilesCloser
implements Feature {
    NativeSecureRandomFilesCloser() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        access.registerReachabilityHandler(NativeSecureRandomFilesCloser::registerShutdownHook, new Object[]{Target_sun_security_provider_NativePRNG.class});
    }

    private static void registerShutdownHook(Feature.DuringAnalysisAccess access) {
        RuntimeSupport.getRuntimeSupport().addTearDownHook(new Runnable(){

            @Override
            public void run() {
                Target_sun_security_provider_NativePRNG_RandomIO instance = Target_sun_security_provider_NativePRNG.INSTANCE;
                if (instance != null) {
                    this.close(instance.nextIn);
                    this.close(instance.seedIn);
                    this.close(instance.seedOut);
                }
            }

            private void close(Closeable stream) {
                if (stream != null) {
                    Closeable c = stream;
                    if (stream instanceof FilterInputStream) {
                        Target_java_io_FilterInputStream outer = SubstrateUtil.cast(c, Target_java_io_FilterInputStream.class);
                        c = outer.in;
                    }
                    try {
                        c.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

