/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.log;

import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.log.RealLog;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.UnsignedWord;

public class RawBufferLog
extends RealLog {
    CCharPointer rawBuffer;
    int rawBufferSize;
    int rawBufferPos;

    public void setRawBuffer(CCharPointer rawBuffer, int rawBufferSize) {
        this.rawBuffer = rawBuffer;
        this.rawBufferSize = rawBufferSize;
        this.rawBufferPos = 0;
    }

    public int getRawBufferPos() {
        return this.rawBufferPos;
    }

    public int getRawBufferBytesLeft() {
        return this.rawBufferSize - this.rawBufferPos;
    }

    @Override
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="This implementation only allocates on the stack.")
    protected Log rawBytes(CCharPointer bytes, UnsignedWord lenghtAsWord) {
        int lenght = (int)lenghtAsWord.rawValue();
        int bytesLeft = this.getRawBufferBytesLeft();
        int index = 0;
        for (int bytesToWrite = Math.min(bytesLeft, lenght); bytesToWrite > 0; --bytesToWrite) {
            this.rawBuffer.write(this.rawBufferPos++, bytes.read(index++));
        }
        return this;
    }

    @Override
    public Log flush() {
        return this;
    }
}

