/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.aarch64;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.aarch64.AArch64ReservedRegisters;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64Backend;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64LoweringProvider;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64RegisterConfig;
import com.oracle.svm.core.graal.aarch64.SubstrateAArch64SuitesCreatorProvider;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateBackendFactory;
import com.oracle.svm.core.graal.code.SubstrateLoweringProviderFactory;
import com.oracle.svm.core.graal.code.SubstrateRegisterConfigFactory;
import com.oracle.svm.core.graal.code.SubstrateSuitesCreatorProvider;
import com.oracle.svm.core.graal.meta.SubstrateRegisterConfig;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.nodes.spi.PlatformConfigurationProvider;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.DefaultJavaLoweringProvider;
import org.graalvm.compiler.replacements.TargetGraphBuilderPlugins;
import org.graalvm.compiler.replacements.aarch64.AArch64GraphBuilderPlugins;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
@Platforms(value={Platform.AARCH64.class})
class SubstrateAArch64Feature
implements Feature {
    SubstrateAArch64Feature() {
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(SubstrateRegisterConfigFactory.class, (Object)new SubstrateRegisterConfigFactory(){

            @Override
            public RegisterConfig newRegisterFactory(SubstrateRegisterConfig.ConfigKind config, MetaAccessProvider metaAccess, TargetDescription target, Boolean preserveFramePointer) {
                return new SubstrateAArch64RegisterConfig(config, metaAccess, target);
            }
        });
        ImageSingletons.add(ReservedRegisters.class, (Object)new AArch64ReservedRegisters());
        if (!SubstrateOptions.useLLVMBackend()) {
            ImageSingletons.add(SubstrateBackendFactory.class, (Object)new SubstrateBackendFactory(){

                @Override
                public SubstrateBackend newBackend(Providers newProviders) {
                    return new SubstrateAArch64Backend(newProviders);
                }
            });
            ImageSingletons.add(SubstrateLoweringProviderFactory.class, (Object)new SubstrateLoweringProviderFactory(){

                @Override
                public DefaultJavaLoweringProvider newLoweringProvider(MetaAccessProvider metaAccess, ForeignCallsProvider foreignCalls, PlatformConfigurationProvider platformConfig, MetaAccessExtensionProvider metaAccessExtensionProvider, TargetDescription target) {
                    return new SubstrateAArch64LoweringProvider(metaAccess, foreignCalls, platformConfig, metaAccessExtensionProvider, target);
                }
            });
            ImageSingletons.add(TargetGraphBuilderPlugins.class, (Object)new AArch64GraphBuilderPlugins());
            ImageSingletons.add(SubstrateSuitesCreatorProvider.class, (Object)new SubstrateAArch64SuitesCreatorProvider());
        }
    }
}

