/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.util.VMError;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class MemoryUtil {
    @Uninterruptible(reason="Arguments may be managed objects")
    public static void copyConjointMemoryAtomic(Pointer from, Pointer to, UnsignedWord size) {
        Pointer bits = from.or((UnsignedWord)to).or(size);
        if (bits.unsignedRemainder(8).equal(0)) {
            MemoryUtil.copyConjointLongsAtomic(from, to, size);
        } else if (bits.unsignedRemainder(4).equal(0)) {
            MemoryUtil.copyConjointIntsAtomic(from, to, size);
        } else if (bits.unsignedRemainder(2).equal(0)) {
            MemoryUtil.copyConjointShortsAtomic(from, to, size);
        } else {
            MemoryUtil.copyConjointBytesAtomic(from, to, size);
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointBytesAtomic(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeByte((WordBase)offset, from.readByte((WordBase)offset));
                    offset = offset.add(1);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeByte((WordBase)offset.subtract(1), from.readByte((WordBase)offset.subtract(1)));
                offset = offset.subtract(1);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointShortsAtomic(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeShort((WordBase)offset, from.readShort((WordBase)offset));
                    offset = offset.add(2);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeShort((WordBase)offset.subtract(2), from.readShort((WordBase)offset.subtract(2)));
                offset = offset.subtract(2);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointIntsAtomic(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeInt((WordBase)offset, from.readInt((WordBase)offset));
                    offset = offset.add(4);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeInt((WordBase)offset.subtract(4), from.readInt((WordBase)offset.subtract(4)));
                offset = offset.subtract(4);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointLongsAtomic(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeLong((WordBase)offset, from.readLong((WordBase)offset));
                    offset = offset.add(8);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeLong((WordBase)offset.subtract(8), from.readLong((WordBase)offset.subtract(8)));
                offset = offset.subtract(8);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    public static void fillToMemoryAtomic(Pointer to, UnsignedWord size, byte value) {
        Pointer bits = to.or(size);
        if (bits.unsignedRemainder(8).equal(0)) {
            long fill = (long)value & 0xFFL;
            if (fill != 0L) {
                fill += fill << 8;
                fill += fill << 16;
                fill += fill << 32;
            }
            UnsignedWord offset = (UnsignedWord)WordFactory.zero();
            while (offset.belowThan(size)) {
                to.writeLong((WordBase)offset, fill);
                offset = offset.add(8);
            }
        } else if (bits.unsignedRemainder(4).equal(0)) {
            int fill = value & 0xFF;
            if (fill != 0) {
                fill += fill << 8;
                fill += fill << 16;
            }
            UnsignedWord offset = (UnsignedWord)WordFactory.zero();
            while (offset.belowThan(size)) {
                to.writeInt((WordBase)offset, fill);
                offset = offset.add(4);
            }
        } else if (bits.unsignedRemainder(2).equal(0)) {
            short fill = (short)(value & 0xFF);
            if (fill != 0) {
                fill = (short)(fill + (fill << 8));
            }
            UnsignedWord offset = (UnsignedWord)WordFactory.zero();
            while (offset.belowThan(size)) {
                to.writeShort((WordBase)offset, fill);
                offset = offset.add(2);
            }
        } else {
            byte fill = value;
            UnsignedWord offset = (UnsignedWord)WordFactory.zero();
            while (offset.belowThan(size)) {
                to.writeByte((WordBase)offset, fill);
                offset = offset.add(1);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    public static void copyConjointSwap(Pointer from, Pointer to, UnsignedWord size, UnsignedWord elementSize) {
        assert (from.isNonNull()) : "address must not be NULL";
        assert (to.isNonNull()) : "address must not be NULL";
        assert (size.unsignedRemainder(elementSize).equal(0)) : "byte count must be multiple of element size";
        if (elementSize.equal(2)) {
            MemoryUtil.copyConjointSwap2(from, to, size);
        } else if (elementSize.equal(4)) {
            MemoryUtil.copyConjointSwap4(from, to, size);
        } else if (elementSize.equal(8)) {
            MemoryUtil.copyConjointSwap8(from, to, size);
        } else {
            throw VMError.shouldNotReachHere("incorrect element size");
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointSwap2(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeShort((WordBase)offset, Short.reverseBytes(from.readShort((WordBase)offset)));
                    offset = offset.add(2);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeShort((WordBase)offset.subtract(2), Short.reverseBytes(from.readShort((WordBase)offset.subtract(2))));
                offset = offset.subtract(2);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointSwap4(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeInt((WordBase)offset, Integer.reverseBytes(from.readInt((WordBase)offset)));
                    offset = offset.add(4);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeInt((WordBase)offset.subtract(4), Integer.reverseBytes(from.readInt((WordBase)offset.subtract(4))));
                offset = offset.subtract(4);
            }
        }
    }

    @Uninterruptible(reason="Arguments may be managed objects")
    private static void copyConjointSwap8(Pointer from, Pointer to, UnsignedWord size) {
        block3: {
            block2: {
                if (!from.aboveThan((UnsignedWord)to)) break block2;
                UnsignedWord offset = (UnsignedWord)WordFactory.zero();
                while (offset.belowThan(size)) {
                    to.writeLong((WordBase)offset, Long.reverseBytes(from.readLong((WordBase)offset)));
                    offset = offset.add(8);
                }
                break block3;
            }
            if (!from.belowThan((UnsignedWord)to)) break block3;
            UnsignedWord offset = size;
            while (offset.aboveThan(0)) {
                to.writeLong((WordBase)offset.subtract(8), Long.reverseBytes(from.readLong((WordBase)offset.subtract(8))));
                offset = offset.subtract(8);
            }
        }
    }
}

