/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.linux;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Resource;
import com.oracle.svm.core.posix.headers.Stat;
import com.oracle.svm.core.posix.headers.Statvfs;
import com.oracle.svm.core.posix.headers.Stdio;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.headers.linux.LinuxSendfile;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class})
class Linux64Suffix {
    Linux64Suffix() {
    }

    @TargetClass(value=LinuxSendfile.class)
    static final class Target_com_oracle_svm_core_posix_headers_linux_LinuxSendfile {
        Target_com_oracle_svm_core_posix_headers_linux_LinuxSendfile() {
        }

        @Substitute
        @CFunction(value="sendfile64")
        private static native SignedWord sendfile(int var0, int var1, CLongPointer var2, UnsignedWord var3);
    }

    @TargetClass(value=Unistd.class)
    static final class Target_com_oracle_svm_core_posix_headers_Unistd {
        Target_com_oracle_svm_core_posix_headers_Unistd() {
        }

        @Substitute
        @CFunction(value="pread64")
        private static native SignedWord pread(int var0, PointerBase var1, UnsignedWord var2, long var3);

        @Substitute
        @CFunction(value="pwrite64")
        private static native SignedWord pwrite(int var0, PointerBase var1, UnsignedWord var2, long var3);

        @Substitute
        @CFunction(value="ftruncate64")
        private static native int ftruncate(int var0, long var1);
    }

    @TargetClass(value=Stdio.class)
    static final class Target_com_oracle_svm_core_posix_headers_Stdio {
        Target_com_oracle_svm_core_posix_headers_Stdio() {
        }

        @Substitute
        @CFunction(value="fopen64")
        private static native Stdio.FILE fopen(CCharPointer var0, CCharPointer var1);
    }

    @TargetClass(value=Statvfs.class)
    static final class Target_com_oracle_svm_core_posix_headers_Statvfs {
        Target_com_oracle_svm_core_posix_headers_Statvfs() {
        }

        @Substitute
        @CFunction(value="statvfs64")
        private static native int statvfs(CCharPointer var0, Statvfs.statvfs var1);

        @Substitute
        @CFunction(value="fstatvfs64")
        private static native int fstatvfs(int var0, Statvfs.statvfs var1);
    }

    @TargetClass(value=Statvfs.statvfs.class)
    @Substitute
    @CStruct(addStructKeyword=true)
    @CContext(value=PosixDirectives.class)
    static interface statvfs64
    extends PointerBase {
        @KeepOriginal
        public long f_bsize();

        @KeepOriginal
        public long f_frsize();

        @KeepOriginal
        public long f_blocks();

        @KeepOriginal
        public long f_bfree();

        @KeepOriginal
        public long f_bavail();

        @KeepOriginal
        public long f_files();

        @KeepOriginal
        public long f_ffree();

        @KeepOriginal
        public long f_favail();

        @KeepOriginal
        public long f_fsid();

        @KeepOriginal
        public long f_flag();

        @KeepOriginal
        public long f_namemax();
    }

    @TargetClass(value=Stat.class)
    static final class Target_com_oracle_svm_core_posix_headers_Stat {
        Target_com_oracle_svm_core_posix_headers_Stat() {
        }

        @Substitute
        @CFunction(value="stat64")
        private static native int stat(CCharPointer var0, Stat.stat var1);

        @Substitute
        @CFunction(value="fstat64")
        private static native int fstat(int var0, Stat.stat var1);

        @Substitute
        @CFunction(value="fstatat64")
        private static native int fstatat(int var0, CCharPointer var1, Stat.stat var2, int var3);

        @Substitute
        @CFunction(value="lstat64")
        private static native int lstat(CCharPointer var0, Stat.stat var1);
    }

    @TargetClass(value=Stat.stat.class)
    @Substitute
    @CStruct(addStructKeyword=true)
    @CContext(value=PosixDirectives.class)
    static interface stat64
    extends PointerBase {
        @KeepOriginal
        public long st_dev();

        @KeepOriginal
        public long st_ino();

        @KeepOriginal
        public int st_mode();

        @KeepOriginal
        public long st_nlink();

        @KeepOriginal
        public int st_uid();

        @KeepOriginal
        public int st_gid();

        @KeepOriginal
        public long st_rdev();

        @KeepOriginal
        public long st_size();

        @KeepOriginal
        public long st_blksize();

        @KeepOriginal
        public long st_blocks();

        @KeepOriginal
        public long st_atime();

        @KeepOriginal
        public long st_mtime();

        @KeepOriginal
        public long st_ctime();
    }

    @TargetClass(value=Resource.class)
    static final class Target_com_oracle_svm_core_posix_headers_Resource {
        Target_com_oracle_svm_core_posix_headers_Resource() {
        }

        @Substitute
        @CFunction(value="getrlimit64")
        private static native int getrlimit(int var0, rlimit64 var1);

        @Substitute
        @CFunction(value="setrlimit64")
        private static native int setrlimit(int var0, rlimit64 var1);
    }

    @TargetClass(value=Resource.rlimit.class)
    @Substitute
    @CStruct(addStructKeyword=true)
    @CContext(value=PosixDirectives.class)
    static interface rlimit64
    extends PointerBase {
        @KeepOriginal
        public UnsignedWord rlim_cur();

        @KeepOriginal
        public void set_rlim_cur(UnsignedWord var1);

        @KeepOriginal
        public UnsignedWord rlim_max();

        @KeepOriginal
        public void set_rlim_max(UnsignedWord var1);
    }

    @TargetClass(value=Mman.class)
    static final class Target_com_oracle_svm_core_posix_headers_Mman {
        Target_com_oracle_svm_core_posix_headers_Mman() {
        }

        @Substitute
        @CFunction(value="mmap64")
        private static native Pointer mmap(PointerBase var0, UnsignedWord var1, int var2, int var3, int var4, long var5);
    }

    @TargetClass(value=Fcntl.class)
    @CContext(value=PosixDirectives.class)
    static final class Target_com_oracle_svm_core_posix_headers_Fcntl {
        Target_com_oracle_svm_core_posix_headers_Fcntl() {
        }

        @Substitute
        @CConstant(value="F_SETLK64")
        private static native int F_SETLK();

        @Substitute
        @CConstant(value="F_SETLKW64")
        private static native int F_SETLKW();
    }

    @TargetClass(value=Fcntl.flock.class)
    @Substitute
    @CStruct(addStructKeyword=true)
    @CContext(value=PosixDirectives.class)
    static interface flock64
    extends PointerBase {
        @KeepOriginal
        public short l_type();

        @KeepOriginal
        public void set_l_type(short var1);

        @KeepOriginal
        public short l_whence();

        @KeepOriginal
        public void set_l_whence(short var1);

        @KeepOriginal
        public SignedWord l_start();

        @KeepOriginal
        public void set_l_start(SignedWord var1);

        @KeepOriginal
        public SignedWord l_len();

        @KeepOriginal
        public void set_l_len(SignedWord var1);

        @KeepOriginal
        public int l_pid();

        @KeepOriginal
        public void set_l_pid(int var1);
    }

    @TargetClass(value=Dirent.class)
    static final class Target_com_oracle_svm_core_posix_headers_Dirent {
        Target_com_oracle_svm_core_posix_headers_Dirent() {
        }

        @Substitute
        @CFunction(value="readdir64_r")
        private static native int readdir_r(Dirent.DIR var0, Dirent.dirent var1, Dirent.direntPointer var2);

        @Substitute
        @CFunction(value="readdir64_r", transition=CFunction.Transition.NO_TRANSITION)
        private static native int readdir_r_no_transition(Dirent.DIR var0, Dirent.dirent var1, Dirent.direntPointer var2);
    }

    @TargetClass(value=Dirent.dirent.class)
    @Substitute
    @CStruct(addStructKeyword=true)
    @CContext(value=PosixDirectives.class)
    static interface dirent64
    extends PointerBase {
        @KeepOriginal
        public long d_ino();

        @KeepOriginal
        public CCharPointer d_name();
    }
}

