/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import java.lang.reflect.AnnotatedType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class AnnotatedSuperInfo {
    private static final AnnotatedType[] EMPTY_ANNOTATED_TYPE_ARRAY = new AnnotatedType[0];
    private static final AnnotatedSuperInfo EMPTY_ANNOTATED_SUPER_INFO = new AnnotatedSuperInfo(null, EMPTY_ANNOTATED_TYPE_ARRAY);
    private final AnnotatedType annotatedSuperclass;
    private final Object annotatedInterfacesEncoding;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static AnnotatedSuperInfo factory(AnnotatedType annotatedSuperType, AnnotatedType[] annotatedInterfaces) {
        boolean hasAnnotatedInterfaces;
        boolean hasAnnotatedSuperType = annotatedSuperType != null;
        boolean bl = hasAnnotatedInterfaces = annotatedInterfaces != null && annotatedInterfaces.length > 0;
        if (hasAnnotatedSuperType || hasAnnotatedInterfaces) {
            return new AnnotatedSuperInfo(annotatedSuperType, AnnotatedSuperInfo.encodeAnnotatedInterfaces(hasAnnotatedInterfaces, annotatedInterfaces));
        }
        return EMPTY_ANNOTATED_SUPER_INFO;
    }

    private static Object encodeAnnotatedInterfaces(boolean hasAnnotatedInterfaces, AnnotatedType[] annotatedInterfaces) {
        if (hasAnnotatedInterfaces) {
            if (annotatedInterfaces.length == 1) {
                return annotatedInterfaces[0];
            }
            return annotatedInterfaces;
        }
        return EMPTY_ANNOTATED_TYPE_ARRAY;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private AnnotatedSuperInfo(AnnotatedType annotatedSuperclass, Object annotatedInterfaces) {
        this.annotatedSuperclass = annotatedSuperclass;
        this.annotatedInterfacesEncoding = annotatedInterfaces;
    }

    AnnotatedType getAnnotatedSuperclass() {
        return this.annotatedSuperclass;
    }

    AnnotatedType[] getAnnotatedInterfaces() {
        if (this.annotatedInterfacesEncoding == EMPTY_ANNOTATED_TYPE_ARRAY) {
            return EMPTY_ANNOTATED_TYPE_ARRAY;
        }
        if (this.annotatedInterfacesEncoding instanceof AnnotatedType) {
            return new AnnotatedType[]{(AnnotatedType)this.annotatedInterfacesEncoding};
        }
        return (AnnotatedType[])((AnnotatedType[])this.annotatedInterfacesEncoding).clone();
    }
}

