/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c;

import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

public class NativeImageHeaderPreamble {
    public static List<String> read(ClassLoader imageClassloader, String preambleResource) {
        return NativeImageHeaderPreamble.getResource(imageClassloader, preambleResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getResource(ClassLoader imageClassloader, String resourceName) {
        try (InputStream input = imageClassloader.getResourceAsStream(resourceName);){
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

