/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.Utf8;
import com.oracle.objectfile.pecoff.cv.CVDebugInfo;
import com.oracle.objectfile.pecoff.cv.CVFileTableRecord;
import com.oracle.objectfile.pecoff.cv.CVSectionImpl;
import com.oracle.objectfile.pecoff.cv.CVStringTableRecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolRecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubrecord;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubsection;
import com.oracle.objectfile.pecoff.cv.CVSymbolSubsectionBuilder;
import com.oracle.objectfile.pecoff.cv.CVUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.graalvm.compiler.debug.DebugContext;

public final class CVSymbolSectionImpl
extends CVSectionImpl {
    private static final int CV_VECTOR_DEFAULT_SIZE = 200;
    private static final int CV_STRINGTABLE_DEFAULT_SIZE = 200;
    private final ArrayList<CVSymbolRecord> cvRecords = new ArrayList(200);
    private final CVStringTable stringTable = new CVStringTable(200);
    private final CVFileTableRecord fileTableRecord;

    CVSymbolSectionImpl(CVDebugInfo cvDebugInfo) {
        super(cvDebugInfo);
        this.fileTableRecord = new CVFileTableRecord(cvDebugInfo, this.stringTable);
    }

    @Override
    public String getSectionName() {
        return ".debug$S";
    }

    @Override
    public void createContent(DebugContext debugContext) {
        int pos = 0;
        this.enableLog(debugContext);
        this.log("CVSymbolSectionImpl.createContent() adding records", new Object[0]);
        this.addRecords();
        this.log("CVSymbolSectionImpl.createContent() start", new Object[0]);
        pos += 4;
        for (CVSymbolRecord record : this.cvRecords) {
            pos = CVUtil.align4(pos);
            pos = record.computeFullSize(pos);
        }
        byte[] buffer = new byte[pos];
        super.setContent(buffer);
        this.log("CVSymbolSectionImpl.createContent() end", new Object[0]);
    }

    @Override
    public void writeContent(DebugContext debugContext) {
        int pos = 0;
        this.enableLog(debugContext);
        this.log("CVSymbolSectionImpl.writeContent() start recordcount=%d", this.cvRecords.size());
        byte[] buffer = this.getContent();
        this.log("  [0x%08x] CV_SIGNATURE_C13", pos);
        pos = CVUtil.putInt(4, buffer, pos);
        for (CVSymbolRecord record : this.cvRecords) {
            pos = CVUtil.align4(pos);
            this.log("  [0x%08x] %s", pos, record.toString());
            record.logContents();
            pos = record.computeFullContents(buffer, pos);
        }
        this.log("CVSymbolSectionImpl.writeContent() end", new Object[0]);
    }

    private void addRecords() {
        this.addPrologueRecord();
        this.addFunctionRecords();
        this.addFileRecord();
        this.addStringTableRecord();
    }

    private void addPrologueRecord() {
        CVSymbolSubsection prologue = new CVSymbolSubsection(this.getCvDebugInfo());
        CVSymbolSubrecord.CVObjectNameRecord objectNameRecord = new CVSymbolSubrecord.CVObjectNameRecord(this.getCvDebugInfo());
        if (objectNameRecord.isValid()) {
            prologue.addRecord(objectNameRecord);
        }
        prologue.addRecord(new CVSymbolSubrecord.CVCompile3Record(this.getCvDebugInfo()));
        prologue.addRecord(new CVSymbolSubrecord.CVEnvBlockRecord(this.getCvDebugInfo()));
        this.addRecord(prologue);
    }

    private void addFunctionRecords() {
        new CVSymbolSubsectionBuilder(this.getCvDebugInfo()).build();
    }

    private void addFileRecord() {
        this.addRecord(this.fileTableRecord);
    }

    CVFileTableRecord getFileTableRecord() {
        return this.fileTableRecord;
    }

    private void addStringTableRecord() {
        CVStringTableRecord stringTableRecord = new CVStringTableRecord(this.getCvDebugInfo(), this.stringTable);
        this.addRecord(stringTableRecord);
    }

    void addRecord(CVSymbolRecord record) {
        this.cvRecords.add(record);
    }

    public int markRelocationSite(byte[] buffer, int initialPos, String symbolName) {
        return this.markRelocationSite(buffer, initialPos, symbolName, 0L);
    }

    public int markRelocationSite(byte[] buffer, int initialPos, String symbolName, long offset) {
        int pos = this.markRelocationSite(buffer, initialPos, symbolName, ObjectFile.RelocationKind.SECREL_4, offset);
        return this.markRelocationSite(buffer, pos, symbolName, ObjectFile.RelocationKind.SECTION_2, 0L);
    }

    private int markRelocationSite(byte[] buffer, int initialPos, String symbolName, ObjectFile.RelocationKind kind, long offset) {
        if (buffer != null) {
            this.markRelocationSite(initialPos, kind, symbolName, offset);
        }
        return initialPos + ObjectFile.RelocationKind.getRelocationSize(kind);
    }

    static final class CVStringTable {
        private final HashMap<String, StringTableEntry> strings;
        private int currentOffset = 0;

        CVStringTable(int startSize) {
            this.strings = new LinkedHashMap<String, StringTableEntry>(startSize);
            this.add("");
        }

        int add(String s) {
            StringTableEntry newEntry = new StringTableEntry(this.currentOffset, s);
            StringTableEntry entry = this.strings.putIfAbsent(s, newEntry);
            if (entry == null) {
                this.currentOffset += Utf8.utf8Length(s) + 1;
            }
            return entry == null ? newEntry.offset : entry.offset;
        }

        Collection<StringTableEntry> values() {
            return this.strings.values();
        }

        int size() {
            return this.strings.size();
        }

        int getCurrentOffset() {
            return this.currentOffset;
        }

        static final class StringTableEntry {
            public int offset;
            public String text;

            StringTableEntry(int offset, String text) {
                this.offset = offset;
                this.text = text;
            }
        }
    }
}

