/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.pecoff.cv;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.BuildDependency;
import com.oracle.objectfile.LayoutDecision;
import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import java.util.Map;
import java.util.Set;
import org.graalvm.compiler.debug.DebugContext;

abstract class CVSectionImpl
extends BasicProgbitsSectionImpl {
    boolean debug = false;

    CVSectionImpl() {
    }

    private String debugSectionLogName() {
        assert (this.getSectionName().startsWith(".debug$"));
        return "PeCoff" + this.getSectionName().replace(".", "");
    }

    protected void enableLog(DebugContext context) {
        if (context.areScopesEnabled()) {
            this.debug = true;
        }
    }

    protected void log(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(2, format, args);
        }
    }

    protected void verboseLog(DebugContext context, String format, Object ... args) {
        if (this.debug) {
            context.logv(3, format, args);
        }
    }

    @Override
    public byte[] getOrDecideContent(Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided, byte[] contentHint) {
        this.getOwner().debugContext(this.debugSectionLogName(), this::createContent);
        this.getOwner().debugContext(this.debugSectionLogName(), this::writeContent);
        return super.getOrDecideContent(alreadyDecided, contentHint);
    }

    @Override
    public Set<BuildDependency> getDependencies(Map<ObjectFile.Element, LayoutDecisionMap> decisions) {
        Iterable deps = super.getDependencies((Map)decisions);
        LayoutDecision ourContent = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.CONTENT);
        LayoutDecision ourSize = decisions.get(this.getElement()).getDecision(LayoutDecision.Kind.SIZE);
        deps.add(BuildDependency.createOrGet(ourSize, ourContent));
        return deps;
    }

    public abstract void createContent(DebugContext var1);

    public abstract void writeContent(DebugContext var1);

    public abstract String getSectionName();
}

