/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debuginfo;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.DebugContext;

public interface DebugInfoProvider {
    public boolean useHeapBase();

    public int oopCompressShift();

    public int oopTagsMask();

    public int oopReferenceSize();

    public int pointerSize();

    public int oopAlignment();

    public Stream<DebugTypeInfo> typeInfoProvider();

    public Stream<DebugCodeInfo> codeInfoProvider();

    public Stream<DebugDataInfo> dataInfoProvider();

    public static interface DebugFrameSizeChange {
        public int getOffset();

        public Type getType();

        public static enum Type {
            EXTEND,
            CONTRACT;

        }
    }

    public static interface DebugLineInfo
    extends DebugRangeInfo {
        public int addressLo();

        public int addressHi();

        public int line();

        public DebugLineInfo getCaller();
    }

    public static interface DebugDataInfo {
        public void debugContext(Consumer<DebugContext> var1);

        public String getProvenance();

        public String getTypeName();

        public String getPartition();

        public long getOffset();

        public long getAddress();

        public long getSize();
    }

    public static interface DebugCodeInfo
    extends DebugRangeInfo {
        public void debugContext(Consumer<DebugContext> var1);

        public int addressLo();

        public int addressHi();

        public int line();

        public Stream<DebugLineInfo> lineInfoProvider();

        public int getFrameSize();

        public List<DebugFrameSizeChange> getFrameSizeChanges();
    }

    public static interface DebugRangeInfo
    extends DebugMethodInfo {
        public ResolvedJavaType ownerType();
    }

    public static interface DebugMethodInfo
    extends DebugMemberInfo {
        public List<String> paramTypes();

        public List<String> paramNames();

        public String symbolNameForMethod();

        public boolean isDeoptTarget();
    }

    public static interface DebugFieldInfo
    extends DebugMemberInfo {
        public int offset();

        public int size();
    }

    public static interface DebugMemberInfo
    extends DebugFileInfo {
        public String name();

        public String valueType();

        public int modifiers();
    }

    public static interface DebugHeaderTypeInfo
    extends DebugTypeInfo {
        public Stream<DebugFieldInfo> fieldInfoProvider();
    }

    public static interface DebugPrimitiveTypeInfo
    extends DebugTypeInfo {
        public static final int FLAG_NUMERIC = 1;
        public static final int FLAG_INTEGRAL = 2;
        public static final int FLAG_SIGNED = 4;

        public int bitCount();

        public char typeChar();

        public int flags();
    }

    public static interface DebugArrayTypeInfo
    extends DebugTypeInfo {
        public int baseSize();

        public int lengthOffset();

        public String elementType();

        public Stream<DebugFieldInfo> fieldInfoProvider();
    }

    public static interface DebugInterfaceTypeInfo
    extends DebugInstanceTypeInfo {
    }

    public static interface DebugEnumTypeInfo
    extends DebugInstanceTypeInfo {
    }

    public static interface DebugInstanceTypeInfo
    extends DebugTypeInfo {
        public int headerSize();

        public Stream<DebugFieldInfo> fieldInfoProvider();

        public Stream<DebugMethodInfo> methodInfoProvider();

        public String superName();

        public Stream<String> interfaces();
    }

    public static interface DebugTypeInfo
    extends DebugFileInfo {
        public void debugContext(Consumer<DebugContext> var1);

        public String typeName();

        public DebugTypeKind typeKind();

        public int size();

        public static enum DebugTypeKind {
            PRIMITIVE,
            ENUM,
            INSTANCE,
            INTERFACE,
            ARRAY,
            HEADER;


            public String toString() {
                switch (this) {
                    case PRIMITIVE: {
                        return "primitive";
                    }
                    case ENUM: {
                        return "enum";
                    }
                    case INSTANCE: {
                        return "instance";
                    }
                    case INTERFACE: {
                        return "interface";
                    }
                    case ARRAY: {
                        return "array";
                    }
                    case HEADER: {
                        return "header";
                    }
                }
                return "???";
            }
        }
    }

    public static interface DebugFileInfo {
        public String fileName();

        public Path filePath();

        public Path cachePath();
    }
}

