/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.agent.AgentMode;

public class ConditionalAgentMode
implements AgentMode {
    private final String userCodeFilterPath;
    private final String extraFilterPath;
    private final boolean parallel;

    public ConditionalAgentMode(String userCodeFilterPath, String extraFilterPath, boolean parallel) {
        this.userCodeFilterPath = userCodeFilterPath;
        this.extraFilterPath = extraFilterPath;
        this.parallel = parallel;
    }

    @Override
    public List<String> getAgentCommandLine() {
        ArrayList<String> cmdLine = new ArrayList<String>();
        cmdLine.add("config-output-dir={output_dir}");
        if (this.parallel) {
            cmdLine.add("experimental-conditional-config-part");
        } else {
            cmdLine.add("experimental-conditional-config-filter-file=" + this.userCodeFilterPath);
            if (!this.extraFilterPath.isEmpty()) {
                cmdLine.add("conditional-config-class-filter-file=" + this.extraFilterPath);
            }
        }
        return cmdLine;
    }

    @Override
    public List<String> getNativeImageConfigureOptions(List<String> inputDirectories, List<String> outputDirectories) {
        int inputDirCount = inputDirectories.size();
        int outputDirCount = outputDirectories.size();
        if (inputDirCount > 0 && outputDirCount > 0) {
            ArrayList<String> cmdLine = new ArrayList<String>(inputDirCount + outputDirCount + 3);
            if (this.parallel) {
                cmdLine.add("generate-conditional");
                cmdLine.add("--user-code-filter=" + this.userCodeFilterPath);
                if (!this.extraFilterPath.isEmpty()) {
                    cmdLine.add("--class-name-filter=" + this.extraFilterPath);
                }
            } else {
                cmdLine.add("generate");
            }
            AgentConfiguration.appendOptionToValues("--input-dir=", inputDirectories, cmdLine);
            AgentConfiguration.appendOptionToValues("--output-dir=", outputDirectories, cmdLine);
            return cmdLine;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getInputFiles() {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.userCodeFilterPath);
        if (!this.extraFilterPath.isEmpty()) {
            files.add(this.extraFilterPath);
        }
        return files;
    }
}

